/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openstack.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.openstack4j.model.network.Ipv6AddressMode;
import org.openstack4j.model.network.Ipv6RaMode;
import org.openstack4j.model.network.Subnet;

@Path(value="/openstack/neutron/subnets/")
@ApplicationScoped
public class OpenstackNeutronSubnetResource {
    private static final Logger LOG = Logger.getLogger(OpenstackNeutronSubnetResource.class);
    private static final String URI_FORMAT = "openstack-neutron://{{camel.openstack.test.host-url}}?username=user&password=secret&project=project&operation=%s&subsystem=subnets";
    private static final String SUBNET_NAME = "sub1";
    private static final String SUBNET_ID = "3b80198d-4f7b-4f77-9ef5-774d54e17126";
    @Inject
    ProducerTemplate template;

    @Path(value="/getShouldSucceed")
    @POST
    public void getShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackNeutronSubnetResource.getShouldSucceed()");
        String uri = String.format(URI_FORMAT, "get");
        Subnet out = (Subnet)this.template.requestBodyAndHeader(uri, null, "ID", (Object)SUBNET_ID, Subnet.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)SUBNET_NAME, (Object)out.getName());
        Assertions.assertEquals((Object)Ipv6AddressMode.DHCPV6_STATEFUL, (Object)out.getIpv6AddressMode());
        Assertions.assertEquals((Object)Ipv6RaMode.DHCPV6_STATEFUL, (Object)out.getIpv6RaMode());
        Assertions.assertNotNull((Object)out.getDnsNames());
        Assertions.assertTrue((boolean)out.getDnsNames().isEmpty());
    }
}

