/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openstack.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.openstack4j.api.Builders;
import org.openstack4j.model.network.AllowedAddressPair;
import org.openstack4j.model.network.Port;

@Path(value="/openstack/neutron/ports/")
@ApplicationScoped
public class OpenstackNeutronPortResource {
    private static final Logger LOG = Logger.getLogger(OpenstackNeutronPortResource.class);
    private static final String URI_FORMAT = "openstack-neutron://{{camel.openstack.test.host-url}}?username=user&password=secret&project=project&operation=%s&subsystem=ports";
    private static final String NETWORK_ID = "a87cc70a-3e15-4acf-8205-9b711a3531b7";
    @Inject
    ProducerTemplate template;

    @Path(value="/createShouldSucceed")
    @POST
    public void createShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackNeutronPortResource.createShouldSucceed()");
        Port in = (Port)Builders.port().networkId(NETWORK_ID).build();
        String uri = String.format(URI_FORMAT, "create");
        Port out = (Port)this.template.requestBody(uri, (Object)in, Port.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)NETWORK_ID, (Object)out.getNetworkId());
        Assertions.assertNotNull((Object)out.getAllowedAddressPairs());
        Assertions.assertEquals((int)1, (int)out.getAllowedAddressPairs().size());
        AllowedAddressPair allowedAddressPair = (AllowedAddressPair)out.getAllowedAddressPairs().iterator().next();
        Assertions.assertNotNull((Object)allowedAddressPair.getIpAddress());
        Assertions.assertNotNull((Object)allowedAddressPair.getMacAddress());
    }

    @Path(value="/getAllShouldSucceed")
    @POST
    public void getAllShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackNeutronPortResource.getAllShouldSucceed()");
        String uri = String.format(URI_FORMAT, "getAll");
        Port[] ports = (Port[])this.template.requestBody(uri, null, Port[].class);
        Assertions.assertNotNull((Object)ports);
        Assertions.assertEquals((int)2, (int)ports.length);
        Assertions.assertEquals((Object)NETWORK_ID, (Object)ports[0].getNetworkId());
        Assertions.assertEquals((Object)"94225baa-9d3f-4b93-bf12-b41e7ce49cdb", (Object)ports[0].getId());
        Assertions.assertEquals((Object)NETWORK_ID, (Object)ports[1].getNetworkId());
        Assertions.assertEquals((Object)"235b09e0-63c4-47f1-b221-66ba54c21760", (Object)ports[1].getId());
    }
}

