/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openstack.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.openstack4j.api.Builders;
import org.openstack4j.model.identity.v3.User;

@Path(value="/openstack/keystone/users/")
@ApplicationScoped
public class OpenstackKeystoneUserResource {
    private static final Logger LOG = Logger.getLogger(OpenstackKeystoneUserResource.class);
    private static final String URI_FORMAT = "openstack-keystone://{{camel.openstack.test.host-url}}?username=user&password=secret&project=project&operation=%s&subsystem=users";
    private static final String USER_NAME = "foobar";
    private static final String USER_DOMAIN_ID = "default";
    private static final String USER_EMAIL = "foobar@example.org";
    private static final String USER_EMAIL_UPDATED = "updatedFoobar@example.org";
    private static final String USER_ID = "29d5aaaa6d3b471e9c101ae470e649a6";
    @Inject
    ProducerTemplate template;

    @Path(value="/createShouldSucceed")
    @POST
    public void createShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneUserResource.createShouldSucceed()");
        User in = (User)Builders.user().name(USER_NAME).domainId(USER_DOMAIN_ID).email(USER_EMAIL).enabled(true).build();
        String uri = String.format(URI_FORMAT, "create");
        User out = (User)this.template.requestBody(uri, (Object)in, User.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)USER_NAME, (Object)out.getName());
        Assertions.assertEquals((Object)USER_DOMAIN_ID, (Object)out.getDomainId());
        Assertions.assertEquals((Object)USER_EMAIL, (Object)out.getEmail());
        Assertions.assertTrue((boolean)out.isEnabled());
        Assertions.assertEquals((Object)USER_ID, (Object)out.getId());
    }

    @Path(value="/getShouldSucceed")
    @POST
    public void getShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneUserResource.getShouldSucceed()");
        String uri = String.format(URI_FORMAT, "get");
        User out = (User)this.template.requestBodyAndHeader(uri, null, "ID", (Object)USER_ID, User.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)USER_NAME, (Object)out.getName());
        Assertions.assertEquals((Object)USER_DOMAIN_ID, (Object)out.getDomainId());
        Assertions.assertTrue((boolean)out.isEnabled());
        Assertions.assertEquals((Object)USER_ID, (Object)out.getId());
    }

    @Path(value="/getAllShouldSucceed")
    @POST
    public void getAllShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneUserResource.getAllShouldSucceed()");
        String uri = String.format(URI_FORMAT, "getAll");
        User[] users = (User[])this.template.requestBody(uri, null, User[].class);
        Assertions.assertNotNull((Object)users);
        Assertions.assertEquals((int)6, (int)users.length);
        Assertions.assertEquals((Object)"glance", (Object)users[0].getName());
        Assertions.assertEquals((Object)USER_DOMAIN_ID, (Object)users[1].getDomainId());
        Assertions.assertNull((Object)users[2].getEmail());
        Assertions.assertEquals((Object)"7afec08993c24bb09df141e513738030", (Object)users[3].getId());
    }

    @Path(value="/updateShouldSucceed")
    @POST
    public void updateShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneUserResource.updateShouldSucceed()");
        User in = (User)Builders.user().id(USER_ID).email(USER_EMAIL_UPDATED).build();
        String uri = String.format(URI_FORMAT, "update");
        User out = (User)this.template.requestBody(uri, (Object)in, User.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)USER_ID, (Object)out.getId());
        Assertions.assertEquals((Object)USER_EMAIL_UPDATED, (Object)out.getEmail());
    }

    @Path(value="/deleteShouldSucceed")
    @POST
    public void deleteShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneUserResource.deleteShouldSucceed()");
        String uri = String.format(URI_FORMAT, "delete");
        this.template.requestBodyAndHeader(uri, null, "ID", (Object)USER_ID);
    }
}

