/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openstack.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.openstack4j.api.Builders;
import org.openstack4j.model.identity.v3.Region;

@Path(value="/openstack/keystone/regions/")
@ApplicationScoped
public class OpenstackKeystoneRegionResource {
    private static final Logger LOG = Logger.getLogger(OpenstackKeystoneRegionResource.class);
    private static final String URI_FORMAT = "openstack-keystone://{{camel.openstack.test.host-url}}?username=user&password=secret&project=project&operation=%s&subsystem=regions";
    private static final String REGION_ID = "Region_CRUD";
    private static final String REGION_PARENTREGIONID = "RegionOne";
    private static final String REGION_DESCRIPTION = "No description provided.";
    private static final String REGION_DESCRIPTION_UPDATED = "A updated region used for CRUD tests.";
    @Inject
    ProducerTemplate template;

    @Path(value="/createShouldSucceed")
    @POST
    public void createShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneRegionResource.createShouldSucceed()");
        Region in = (Region)Builders.region().id(REGION_ID).description(REGION_DESCRIPTION).parentRegionId(REGION_PARENTREGIONID).build();
        String uri = String.format(URI_FORMAT, "create");
        Region out = (Region)this.template.requestBody(uri, (Object)in, Region.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)REGION_ID, (Object)out.getId());
        Assertions.assertEquals((Object)REGION_DESCRIPTION, (Object)out.getDescription());
        Assertions.assertEquals((Object)REGION_PARENTREGIONID, (Object)out.getParentRegionId());
    }

    @Path(value="/getShouldSucceed")
    @POST
    public void getShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneRegionResource.getShouldSucceed()");
        String uri = String.format(URI_FORMAT, "get");
        Region out = (Region)this.template.requestBodyAndHeader(uri, null, "ID", (Object)REGION_ID, Region.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)REGION_ID, (Object)out.getId());
        Assertions.assertEquals((Object)REGION_DESCRIPTION, (Object)out.getDescription());
        Assertions.assertEquals((Object)REGION_PARENTREGIONID, (Object)out.getParentRegionId());
    }

    @Path(value="/getAllShouldSucceed")
    @POST
    public void getAllShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneRegionResource.getAllShouldSucceed()");
        String uri = String.format(URI_FORMAT, "getAll");
        Region[] regions = (Region[])this.template.requestBody(uri, null, Region[].class);
        Assertions.assertEquals((int)2, (int)regions.length);
        Assertions.assertEquals((Object)REGION_PARENTREGIONID, (Object)regions[0].getId());
        Assertions.assertEquals(null, (Object)regions[0].getParentRegionId());
        Assertions.assertEquals((Object)REGION_ID, (Object)regions[1].getId());
        Assertions.assertEquals((Object)REGION_PARENTREGIONID, (Object)regions[1].getParentRegionId());
    }

    @Path(value="/updateShouldSucceed")
    @POST
    public void updateShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneRegionResource.updateShouldSucceed()");
        Region in = (Region)Builders.region().id(REGION_ID).description(REGION_DESCRIPTION_UPDATED).build();
        String uri = String.format(URI_FORMAT, "update");
        Region out = (Region)this.template.requestBody(uri, (Object)in, Region.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)REGION_ID, (Object)out.getId());
        Assertions.assertEquals((Object)REGION_DESCRIPTION_UPDATED, (Object)out.getDescription());
        Assertions.assertEquals((Object)REGION_PARENTREGIONID, (Object)out.getParentRegionId());
    }

    @Path(value="/deleteShouldSucceed")
    @POST
    public void deleteShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneRegionResource.deleteShouldSucceed()");
        String uri = String.format(URI_FORMAT, "delete");
        this.template.requestBodyAndHeader(uri, null, "ID", (Object)REGION_ID);
    }

    @Path(value="/getUnknownShouldReturnNull")
    @POST
    public void getUnknownRegionShouldReturnNull() {
        LOG.debug((Object)"Calling OpenstackKeystoneRegionResource.getUnknownShouldReturnNull()");
        String uri = String.format(URI_FORMAT, "get");
        Region out = (Region)this.template.requestBodyAndHeader(uri, null, "ID", (Object)"nonExistentRegionId", Region.class);
        Assertions.assertNull((Object)out);
    }
}

