/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openstack.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.openstack4j.api.Builders;
import org.openstack4j.model.identity.v3.Project;

@Path(value="/openstack/keystone/projects/")
@ApplicationScoped
public class OpenstackKeystoneProjectResource {
    private static final Logger LOG = Logger.getLogger(OpenstackKeystoneProjectResource.class);
    private static final String URI_FORMAT = "openstack-keystone://{{camel.openstack.test.host-url}}?username=user&password=secret&project=project&operation=%s&subsystem=projects";
    private static final String PROJECT_NAME = "ProjectX";
    private static final String PROJECT_ID = "3337151a1c38496c8bffcb280b19c346";
    private static final String PROJECT_DOMAIN_ID = "7a71863c2d1d4444b3e6c2cd36955e1e";
    private static final String PROJECT_DESCRIPTION = "Project used for CRUD tests";
    private static final String PROJECT_DESCRIPTION_UPDATED = "An updated project used for CRUD tests";
    private static final String PROJECT_EXTRA_KEY_1 = "extra_key1";
    private static final String PROJECT_EXTRA_VALUE_1 = "value1";
    private static final String PROJECT_EXTRA_KEY_2 = "extra_key2";
    private static final String PROJECT_EXTRA_VALUE_2 = "value2";
    private static final List<String> TAGS = Arrays.asList("one", "two", "three");
    @Inject
    ProducerTemplate template;

    @Path(value="/createShouldSucceed")
    @POST
    public void createShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneProjectResource.createShouldSucceed()");
        Project in = (Project)Builders.project().name(PROJECT_NAME).description(PROJECT_DESCRIPTION).domainId(PROJECT_DOMAIN_ID).setExtra(PROJECT_EXTRA_KEY_1, PROJECT_EXTRA_VALUE_1).enabled(true).setTags(TAGS).build();
        String uri = String.format(URI_FORMAT, "create");
        Project out = (Project)this.template.requestBody(uri, (Object)in, Project.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)PROJECT_NAME, (Object)out.getName());
        Assertions.assertEquals((Object)PROJECT_ID, (Object)out.getId());
        Assertions.assertEquals((Object)PROJECT_DOMAIN_ID, (Object)out.getDomainId());
        Assertions.assertEquals((Object)PROJECT_DESCRIPTION, (Object)out.getDescription());
        Assertions.assertEquals((Object)PROJECT_EXTRA_VALUE_1, (Object)out.getExtra(PROJECT_EXTRA_KEY_1));
        Assertions.assertEquals(TAGS, (Object)out.getTags());
    }

    @Path(value="/getShouldSucceed")
    @POST
    public void getShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneProjectResource.getShouldSucceed()");
        String uri = String.format(URI_FORMAT, "get");
        Project out = (Project)this.template.requestBodyAndHeader(uri, null, "ID", (Object)PROJECT_ID, Project.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)PROJECT_NAME, (Object)out.getName());
        Assertions.assertEquals((Object)PROJECT_ID, (Object)out.getId());
        Assertions.assertEquals((Object)PROJECT_DOMAIN_ID, (Object)out.getDomainId());
        Assertions.assertEquals((Object)PROJECT_DESCRIPTION, (Object)out.getDescription());
    }

    @Path(value="/getAllShouldSucceed")
    @POST
    public void getAllShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneProjectResource.getAllShouldSucceed()");
        String uri = String.format(URI_FORMAT, "getAll");
        Project[] projects = (Project[])this.template.requestBody(uri, null, Project[].class);
        Assertions.assertEquals((int)3, (int)projects.length);
        Assertions.assertEquals((Object)"10b40033bbef48f89fe838fef62398f0", (Object)projects[0].getId());
        Assertions.assertEquals((Object)"600905d353a84b20b644d2fe55a21e8a", (Object)projects[1].getId());
        Assertions.assertEquals((Object)"8519dba9f4594f0f87071c87784a8d2c", (Object)projects[2].getId());
        Assertions.assertNotNull((Object)projects[2].getOptions());
        Assertions.assertTrue((boolean)projects[2].getOptions().isEmpty());
        Assertions.assertNotNull((Object)projects[2].getTags());
        Assertions.assertTrue((boolean)projects[2].getTags().isEmpty());
    }

    @Path(value="/updateShouldSucceed")
    @POST
    public void updateShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneProjectResource.updateShouldSucceed()");
        Project in = (Project)Builders.project().id(PROJECT_ID).description(PROJECT_DESCRIPTION_UPDATED).setExtra(PROJECT_EXTRA_KEY_2, PROJECT_EXTRA_VALUE_2).build();
        String uri = String.format(URI_FORMAT, "update");
        Project out = (Project)this.template.requestBody(uri, (Object)in, Project.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)PROJECT_ID, (Object)out.getId());
        Assertions.assertEquals((Object)PROJECT_NAME, (Object)out.getName());
        Assertions.assertEquals((Object)PROJECT_DOMAIN_ID, (Object)out.getDomainId());
        Assertions.assertEquals((Object)PROJECT_DESCRIPTION_UPDATED, (Object)out.getDescription());
        Assertions.assertEquals((Object)PROJECT_EXTRA_VALUE_1, (Object)out.getExtra(PROJECT_EXTRA_KEY_1));
        Assertions.assertEquals((Object)PROJECT_EXTRA_VALUE_2, (Object)out.getExtra(PROJECT_EXTRA_KEY_2));
    }

    @Path(value="/deleteShouldSucceed")
    @POST
    public void deleteShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneProjectResource.deleteShouldSucceed()");
        String uri = String.format(URI_FORMAT, "delete");
        this.template.requestBodyAndHeader(uri, null, "ID", (Object)PROJECT_ID);
    }
}

