/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openstack.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.openstack4j.api.Builders;
import org.openstack4j.model.identity.v3.Domain;

@Path(value="/openstack/keystone/domains/")
@ApplicationScoped
public class OpenstackKeystoneDomainResource {
    private static final Logger LOG = Logger.getLogger(OpenstackKeystoneDomainResource.class);
    private static final String URI_FORMAT = "openstack-keystone://{{camel.openstack.test.host-url}}?username=user&password=secret&project=project&operation=%s&subsystem=domains";
    private static final String DOMAIN_NAME = "Domain_CRUD";
    private static final String DOMAIN_ID = "98c110ae41c249189c9d5c25d8377b65";
    private static final String DOMAIN_DESCRIPTION = "Domain used for CRUD tests";
    private static final String DOMAIN_DESCRIPTION_UPDATED = "An updated domain used for CRUD tests";
    @Inject
    ProducerTemplate template;

    @Path(value="/createShouldSucceed")
    @POST
    public void createShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneDomainResource.createShouldSucceed()");
        Domain in = (Domain)Builders.domain().name(DOMAIN_NAME).description(DOMAIN_DESCRIPTION).enabled(true).build();
        String uri = String.format(URI_FORMAT, "create");
        Domain out = (Domain)this.template.requestBody(uri, (Object)in, Domain.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)DOMAIN_NAME, (Object)out.getName());
        Assertions.assertEquals((Object)DOMAIN_ID, (Object)out.getId());
        Assertions.assertEquals((Object)DOMAIN_DESCRIPTION, (Object)out.getDescription());
    }

    @Path(value="/getShouldSucceed")
    @POST
    public void getShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneDomainResource.getShouldSucceed()");
        String uri = String.format(URI_FORMAT, "get");
        Domain out = (Domain)this.template.requestBodyAndHeader(uri, null, "ID", (Object)DOMAIN_ID, Domain.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)DOMAIN_NAME, (Object)out.getName());
        Assertions.assertEquals((Object)DOMAIN_ID, (Object)out.getId());
        Assertions.assertEquals((Object)DOMAIN_DESCRIPTION, (Object)out.getDescription());
        Assertions.assertFalse((boolean)out.isEnabled());
    }

    @Path(value="/getAllShouldSucceed")
    @POST
    public void getAllShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneDomainResource.getAllShouldSucceed()");
        String uri = String.format(URI_FORMAT, "getAll");
        Domain[] domains = (Domain[])this.template.requestBody(uri, null, Domain[].class);
        Assertions.assertEquals((int)1, (int)domains.length);
        Assertions.assertEquals((Object)"default", (Object)domains[0].getId());
        Assertions.assertNotNull((Object)domains[0].getOptions());
        Assertions.assertTrue((boolean)domains[0].getOptions().isEmpty());
    }

    @Path(value="/updateShouldSucceed")
    @POST
    public void updateShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneDomainResource.updateShouldSucceed()");
        Domain in = (Domain)Builders.domain().name(DOMAIN_NAME).description(DOMAIN_DESCRIPTION_UPDATED).id(DOMAIN_ID).build();
        String uri = String.format(URI_FORMAT, "update");
        Domain out = (Domain)this.template.requestBody(uri, (Object)in, Domain.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)DOMAIN_NAME, (Object)out.getName());
        Assertions.assertEquals((Object)DOMAIN_ID, (Object)out.getId());
        Assertions.assertEquals((Object)DOMAIN_DESCRIPTION_UPDATED, (Object)out.getDescription());
    }

    @Path(value="/deleteShouldSucceed")
    @POST
    public void deleteShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneDomainResource.deleteShouldSucceed()");
        String uri = String.format(URI_FORMAT, "delete");
        this.template.requestBodyAndHeader(uri, null, "ID", (Object)DOMAIN_ID);
    }
}

