/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openstack.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.openstack4j.model.common.Payload;
import org.openstack4j.model.common.Payloads;
import org.openstack4j.model.image.ContainerFormat;
import org.openstack4j.model.image.DiskFormat;
import org.openstack4j.model.image.Image;

@Path(value="/openstack/glance/")
@ApplicationScoped
public class OpenstackGlanceResource {
    private static final Logger LOG = Logger.getLogger(OpenstackGlanceResource.class);
    private static final String URI_FORMAT = "openstack-glance://{{camel.openstack.test.host-url}}?username=user&password=secret&project=project&operation=%s";
    @Inject
    ProducerTemplate template;

    @Path(value="/createShouldSucceed")
    @POST
    public void createShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackGlanceResource.createShouldSucceed()");
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("name", "amphora-x64-haproxy");
        headers.put("diskFormat", DiskFormat.QCOW2);
        headers.put("containerFormat", ContainerFormat.BARE);
        headers.put("minDisk", 0L);
        headers.put("minRam", 0L);
        Payload payload = Payloads.create((InputStream)new ByteArrayInputStream(new byte[]{10, 11, 12}));
        String uri = String.format(URI_FORMAT, "create");
        Image out = (Image)this.template.requestBodyAndHeaders(uri, (Object)payload, headers, Image.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"8a2ea42d-06b5-42c2-a54d-97105420f2bb", (Object)out.getId());
        Assertions.assertEquals((Object)"amphora-x64-haproxy", (Object)out.getName());
        Assertions.assertEquals((Object)ContainerFormat.BARE, (Object)out.getContainerFormat());
        Assertions.assertEquals((Object)DiskFormat.QCOW2, (Object)out.getDiskFormat());
        Assertions.assertEquals((long)0L, (long)out.getMinDisk());
        Assertions.assertEquals((long)0L, (long)out.getMinRam());
    }

    @Path(value="/uploadShouldSucceed")
    @POST
    public void uploadShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackGlanceResource.uploadShouldSucceed()");
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("name", "amphora-x64-haproxy");
        headers.put("ID", "4b434528-032b-4467-946c-b5880ce15c06");
        headers.put("diskFormat", DiskFormat.QCOW2);
        headers.put("containerFormat", ContainerFormat.BARE);
        headers.put("minDisk", 0L);
        headers.put("minRam", 0L);
        Payload payload = Payloads.create((InputStream)new ByteArrayInputStream(new byte[]{10, 11, 12}));
        String uri = String.format(URI_FORMAT, "upload");
        Image out = (Image)this.template.requestBodyAndHeaders(uri, (Object)payload, headers, Image.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"4b434528-032b-4467-946c-b5880ce15c06", (Object)out.getId());
    }

    @Path(value="/getShouldSucceed")
    @POST
    public void getShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackGlanceResource.getShouldSucceed()");
        String uri = String.format(URI_FORMAT, "get");
        String id = "8a2ea42d-06b5-42c2-a54d-97105420f2bb";
        Image out = (Image)this.template.requestBodyAndHeader(uri, null, "ID", (Object)id, Image.class);
        Assertions.assertEquals((Object)id, (Object)out.getId());
    }

    @Path(value="/getAllShouldSucceed")
    @POST
    public void getAllShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackGlanceResource.getAllShouldSucceed()");
        String uri = String.format(URI_FORMAT, "getAll");
        Image[] images = (Image[])this.template.requestBody(uri, null, Image[].class);
        Assertions.assertEquals((int)2, (int)images.length);
        Assertions.assertEquals((Object)"7541b8be-c62b-46c3-b5a5-5bb5ce43ce01", (Object)images[0].getId());
    }

    @Path(value="/deleteShouldSucceed")
    @POST
    public void deleteShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackGlanceResource.deleteShouldSucceed()");
        String uri = String.format(URI_FORMAT, "delete");
        this.template.requestBodyAndHeader(uri, null, "ID", (Object)"8a2ea42d-06b5-42c2-a54d-97105420f2bb");
    }
}

