/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openstack.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.openstack4j.api.Builders;
import org.openstack4j.model.storage.block.Volume;
import org.openstack4j.model.storage.block.VolumeAttachment;
import org.openstack4j.model.storage.block.VolumeType;

@Path(value="/openstack/cinder/volumes/")
@ApplicationScoped
public class OpenstackCinderVolumeResource {
    private static final Logger LOG = Logger.getLogger(OpenstackCinderVolumeResource.class);
    private static final String URI_FORMAT = "openstack-cinder://{{camel.openstack.test.host-url}}?username=user&password=secret&project=project&operation=%s&subsystem=volumes";
    @Inject
    ProducerTemplate template;

    @Path(value="/createShouldSucceed")
    @POST
    public void createShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackCinderVolumeResource.createShouldSucceed()");
        Volume in = (Volume)Builders.volume().size(10).name("test_openstack4j").description("test").multiattach(Boolean.valueOf(true)).build();
        String uri = String.format(URI_FORMAT, "create");
        Volume out = (Volume)this.template.requestBody(uri, (Object)in, Volume.class);
        Assertions.assertEquals((int)10, (int)out.getSize());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)out.multiattach());
    }

    @Path(value="/getShouldSucceed")
    @POST
    public void getShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackCinderVolumeResource.getShouldSucceed()");
        String uri = String.format(URI_FORMAT, "get");
        String id = "8a9287b7-4f4d-4213-8d75-63470f19f27c";
        Volume out = (Volume)this.template.requestBodyAndHeader(uri, null, "volumeId", (Object)id, Volume.class);
        Assertions.assertEquals((Object)id, (Object)out.getId());
        Assertions.assertEquals((Object)"test-volume", (Object)out.getName());
        Assertions.assertEquals((Object)"a description", (Object)out.getDescription());
        Assertions.assertNotNull((Object)out.getCreated());
        Assertions.assertEquals((Object)"nova", (Object)out.getZone());
        Assertions.assertEquals((int)100, (int)out.getSize());
        Assertions.assertEquals((Object)Volume.Status.IN_USE, (Object)out.getStatus());
        Assertions.assertEquals((Object)"22222222-2222-2222-2222-222222222222", (Object)out.getSnapshotId());
        Assertions.assertEquals((Object)"11111111-1111-1111-1111-111111111111", (Object)out.getSourceVolid());
        Assertions.assertEquals((Object)"Gold", (Object)out.getVolumeType());
        Assertions.assertNotNull((Object)out.getMetaData());
        Map metadata = out.getMetaData();
        Assertions.assertEquals((Object)"False", metadata.get("readonly"));
        Assertions.assertEquals((Object)"rw", metadata.get("attached_mode"));
        Assertions.assertNotNull((Object)out.getAttachments());
        List attachments = out.getAttachments();
        Assertions.assertEquals((int)1, (int)attachments.size());
        Assertions.assertEquals((Object)"/dev/vdd", (Object)((VolumeAttachment)attachments.get(0)).getDevice());
        Assertions.assertEquals((Object)"myhost", (Object)((VolumeAttachment)attachments.get(0)).getHostname());
        Assertions.assertEquals((Object)"8a9287b7-4f4d-4213-8d75-63470f19f27c", (Object)((VolumeAttachment)attachments.get(0)).getId());
        Assertions.assertEquals((Object)"eaa6a54d-35c1-40ce-831d-bb61f991e1a9", (Object)((VolumeAttachment)attachments.get(0)).getServerId());
        Assertions.assertEquals((Object)"8a9287b7-4f4d-4213-8d75-63470f19f27c", (Object)((VolumeAttachment)attachments.get(0)).getVolumeId());
    }

    @Path(value="/getAllShouldSucceed")
    @POST
    public void getAllShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackCinderVolumeResource.getAllShouldSucceed()");
        String uri = String.format(URI_FORMAT, "getAll");
        Volume[] volumes = (Volume[])this.template.requestBody(uri, null, Volume[].class);
        Assertions.assertEquals((int)3, (int)volumes.length);
        Assertions.assertEquals((Object)"b0b5ed7ae06049688349fe43737796d4", (Object)volumes[0].getTenantId());
    }

    @Path(value="/getAllTypesShouldSucceed")
    @POST
    public void getAllTypesShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackCinderVolumeResource.getAllTypesShouldSucceed()");
        String uri = String.format(URI_FORMAT, "getAllTypes");
        VolumeType[] volumeTypes = (VolumeType[])this.template.requestBody(uri, null, VolumeType[].class);
        Assertions.assertEquals((int)2, (int)volumeTypes.length);
        Assertions.assertEquals((Object)"6a65bc1b-197b-45bf-8056-9695dc82191f", (Object)volumeTypes[0].getId());
        Assertions.assertEquals((Object)"testVolume1", (Object)volumeTypes[0].getName());
        Assertions.assertNotNull((Object)volumeTypes[0].getExtraSpecs());
        Assertions.assertEquals((Object)"gpu", volumeTypes[0].getExtraSpecs().get("capabilities"));
        Assertions.assertEquals((Object)"10f00bb7-46d8-4f3f-b89b-702693a3dcdc", (Object)volumeTypes[1].getId());
        Assertions.assertEquals((Object)"testVolume2", (Object)volumeTypes[1].getName());
        Assertions.assertNotNull((Object)volumeTypes[1].getExtraSpecs());
        Assertions.assertEquals((Object)"gpu", volumeTypes[1].getExtraSpecs().get("capabilities"));
    }

    @Path(value="/updateShouldSucceed")
    @POST
    public void updateShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackCinderVolumeResource.updateShouldSucceed()");
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("volumeId", "fffab33e-38e8-4626-9fee-fe90f240ff0f");
        headers.put("name", "name");
        headers.put("description", "description");
        headers.put("description", 1024);
        headers.put("volumeType", "volume-type");
        headers.put("imageRef", "image-ref");
        headers.put("snapshotId", "snaphot-id");
        headers.put("isBootable", false);
        String uri = String.format(URI_FORMAT, "update");
        this.template.requestBodyAndHeaders(uri, null, headers);
    }

    @Path(value="/deleteShouldSucceed")
    @POST
    public void deleteShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackCinderVolumeResource.deleteShouldSucceed()");
        String uri = String.format(URI_FORMAT, "delete");
        this.template.requestBodyAndHeader(uri, null, "volumeId", (Object)"fffab33e-38e8-4626-9fee-fe90f240ff0f");
    }
}

