/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openstack.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.Map;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.openstack4j.model.storage.object.SwiftContainer;

@Path(value="/openstack/swift/containers/")
@ApplicationScoped
public class OpenstackSwiftContainerResource {
    private static final Logger LOG = Logger.getLogger(OpenstackSwiftContainerResource.class);
    private static final String URI_FORMAT = "openstack-swift://{{camel.openstack.test.host-url}}?username=user&password=secret&project=project&operation=%s&subsystem=containers";
    private static final String CONTAINER_NAME = "myContainer";
    private static final String NAME_BOOK = "Book";
    private static final String NAME_YEAR = "Year";
    @Inject
    ProducerTemplate template;

    @Path(value="/getAllShouldSucceed")
    @POST
    public void getAllShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackSwiftContainerResource.getAllShouldSucceed()");
        String uri = String.format(URI_FORMAT, "getAll");
        SwiftContainer[] containers = (SwiftContainer[])this.template.requestBody(uri, null, SwiftContainer[].class);
        Assertions.assertNotNull((Object)containers);
        Assertions.assertEquals((int)2, (int)containers.length);
        Assertions.assertEquals((long)100L, (long)containers[0].getTotalSize());
        Assertions.assertEquals((Object)"Test", (Object)containers[0].getName());
        Assertions.assertEquals((Object)"marktwain", (Object)containers[1].getName());
    }

    @Path(value="/getMetadataShouldSucceed")
    @POST
    public void getMetadataShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackSwiftContainerResource.getMetadataShouldSucceed()");
        String uri = String.format(URI_FORMAT, "getMetadata");
        Map metadata = (Map)this.template.requestBodyAndHeader(uri, null, "containerName", (Object)CONTAINER_NAME, Map.class);
        Assertions.assertNotNull((Object)metadata);
        Assertions.assertEquals((Object)"2000", metadata.get(NAME_YEAR));
        Assertions.assertEquals((Object)"TestBook", metadata.get(NAME_BOOK));
    }
}

