/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openstack.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.HashMap;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.openstack4j.api.Builders;
import org.openstack4j.api.exceptions.ServerResponseException;
import org.openstack4j.model.compute.Address;
import org.openstack4j.model.compute.Server;
import org.openstack4j.model.compute.ServerCreate;

@Path(value="/openstack/nova/servers/")
@ApplicationScoped
public class OpenstackNovaServerResource {
    private static final Logger LOG = Logger.getLogger(OpenstackNovaServerResource.class);
    private static final String URI_FORMAT = "openstack-nova://{{camel.openstack.test.host-url}}?username=user&password=secret&project=project&operation=%s&subsystem=servers";
    private static final String SERVER_NAME = "server-test-1";
    private static final String SERVER_ID = "e565cbdb-8e74-4044-ba6e-0155500b2c46";
    private static final String SERVER_WRONG_ID = "05184ba3-00ba-4fbc-b7a2-03b62b884931";
    private static final String SERVER_SNAPSHOT_NAME = "server-snapshot";
    private static final String SERVER_SNAPSHOT_ID = "72f759b3-2576-4bf0-9ac9-7cb4a5b9d541";
    @Inject
    ProducerTemplate template;

    @Path(value="/createShouldSucceed")
    @POST
    public void createShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackNovaServerResource.createShouldSucceed()");
        ServerCreate in = (ServerCreate)Builders.server().name(SERVER_NAME).build();
        String uri = String.format(URI_FORMAT, "create");
        Server out = (Server)this.template.requestBody(uri, (Object)in, Server.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)SERVER_NAME, (Object)out.getName());
    }

    @Path(value="/createSnapshotShouldSucceed")
    @POST
    public void createSnapshotShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackNovaServerResource.createSnapshotShouldSucceed()");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("ID", SERVER_ID);
        headers.put("name", SERVER_SNAPSHOT_NAME);
        String uri = String.format(URI_FORMAT, "createSnapshot");
        String out = (String)this.template.requestBodyAndHeaders(uri, null, headers, String.class);
        Assertions.assertEquals((Object)SERVER_SNAPSHOT_ID, (Object)out);
    }

    @Path(value="/getWrongIdShouldThrow")
    @POST
    public void getWrongIdShouldThrow() {
        LOG.debug((Object)"Calling OpenstackNovaServerResource.getWrongIdShouldThrow()");
        String uri = String.format(URI_FORMAT, "get");
        try {
            this.template.requestBodyAndHeader(uri, null, "ID", (Object)SERVER_WRONG_ID, Server.class);
            Assertions.fail((String)"Getting nova server with wrong id should throw");
        }
        catch (Exception ex) {
            Assertions.assertTrue((boolean)(ex instanceof CamelExecutionException));
            Assertions.assertTrue((boolean)(((CamelExecutionException)ex).getCause() instanceof ServerResponseException));
        }
    }

    @Path(value="/getAllShouldSucceed")
    @POST
    public void getAllShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackNovaServerResource.getAllShouldSucceed()");
        String uri = String.format(URI_FORMAT, "getAll");
        Server[] servers = (Server[])this.template.requestBody(uri, null, Server[].class);
        Assertions.assertNotNull((Object)servers);
        Assertions.assertEquals((int)1, (int)servers.length);
        Server server = servers[0];
        Assertions.assertNotNull((Object)server);
        Assertions.assertNotNull((Object)server.getAddresses());
        Assertions.assertNotNull((Object)server.getAddresses().getAddresses("private"));
        Assertions.assertEquals((int)1, (int)server.getAddresses().getAddresses("private").size());
        Assertions.assertEquals((Object)"192.168.0.3", (Object)((Address)servers[0].getAddresses().getAddresses("private").get(0)).getAddr());
        Assertions.assertEquals((Object)Server.Status.ACTIVE, (Object)servers[0].getStatus());
        Assertions.assertEquals((Object)"new-server-test", (Object)servers[0].getName());
    }
}

