/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openstack.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.openstack4j.api.Builders;
import org.openstack4j.model.compute.Flavor;

@Path(value="/openstack/nova/flavors/")
@ApplicationScoped
public class OpenstackNovaFlavorResource {
    private static final Logger LOG = Logger.getLogger(OpenstackNovaFlavorResource.class);
    private static final String URI_FORMAT = "openstack-nova://{{camel.openstack.test.host-url}}?username=user&password=secret&project=project&operation=%s&subsystem=flavors";
    private static final String FLAVOR_ID = "1";
    private static final String FLAVOR_NAME = "m1.tiny";
    @Inject
    ProducerTemplate template;

    @Path(value="/createShouldSucceed")
    @POST
    public void createShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackNovaFlavorResource.createShouldSucceed()");
        Flavor in = (Flavor)Builders.flavor().name("safe_to_delete_flavor").vcpus(1).disk(2).isPublic(true).rxtxFactor(2.0f).ephemeral(1).ram(128).id("delete_1").swap(1).build();
        String uri = String.format(URI_FORMAT, "create");
        Flavor out = (Flavor)this.template.requestBody(uri, (Object)in, Flavor.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((int)1, (int)out.getVcpus());
        Assertions.assertEquals((int)2, (int)out.getDisk());
        Assertions.assertEquals((Object)FLAVOR_NAME, (Object)out.getName());
        Assertions.assertTrue((boolean)out.isPublic());
        Assertions.assertEquals((float)2.0f, (float)out.getRxtxFactor());
        Assertions.assertEquals((int)1, (int)out.getEphemeral());
        Assertions.assertEquals((int)128, (int)out.getRam());
        Assertions.assertEquals((Object)FLAVOR_ID, (Object)out.getId());
        Assertions.assertEquals((int)1, (int)out.getSwap());
    }

    @Path(value="/getShouldSucceed")
    @POST
    public void getShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackNovaFlavorResource.getShouldSucceed()");
        String uri = String.format(URI_FORMAT, "get");
        Flavor out = (Flavor)this.template.requestBodyAndHeader(uri, null, "ID", (Object)FLAVOR_ID, Flavor.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((int)1, (int)out.getDisk());
        Assertions.assertEquals((Object)FLAVOR_NAME, (Object)out.getName());
        Assertions.assertEquals((int)512, (int)out.getRam());
        Assertions.assertTrue((boolean)out.isPublic());
        Assertions.assertEquals((int)0, (int)out.getEphemeral());
        Assertions.assertFalse((boolean)out.isDisabled());
        Assertions.assertEquals((float)2.0f, (float)out.getRxtxFactor());
        Assertions.assertEquals((int)1, (int)out.getVcpus());
    }

    @Path(value="/getAllShouldSucceed")
    @POST
    public void getAllShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackNovaFlavorResource.getAllShouldSucceed()");
        String uri = String.format(URI_FORMAT, "getAll");
        Flavor[] flavors = (Flavor[])this.template.requestBody(uri, null, Flavor[].class);
        Assertions.assertNotNull((Object)flavors);
        Assertions.assertEquals((int)2, (int)flavors.length);
    }
}

