/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openstack.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.openstack4j.api.Builders;
import org.openstack4j.model.network.Network;
import org.openstack4j.model.network.NetworkType;
import org.openstack4j.model.network.State;

@Path(value="/openstack/neutron/networks/")
@ApplicationScoped
public class OpenstackNeutronNetworkResource {
    private static final Logger LOG = Logger.getLogger(OpenstackNeutronNetworkResource.class);
    private static final String URI_FORMAT = "openstack-neutron://{{camel.openstack.test.host-url}}?username=user&password=secret&project=project&operation=%s&subsystem=networks";
    private static final String NETWORK_NAME = "net1";
    private static final String NETWORK_ID = "4e8e5957-649f-477b-9e5b-f1f75b21c03c";
    @Inject
    ProducerTemplate template;

    @Path(value="/createShouldSucceed")
    @POST
    public void createShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackNeutronNetworkResource.createShouldSucceed()");
        Network in = (Network)Builders.network().name(NETWORK_NAME).isRouterExternal(true).adminStateUp(true).build();
        String uri = String.format(URI_FORMAT, "create");
        Network out = (Network)this.template.requestBody(uri, (Object)in, Network.class);
        Assertions.assertEquals((Object)NETWORK_NAME, (Object)out.getName());
        Assertions.assertEquals((Object)State.ACTIVE, (Object)out.getStatus());
        Assertions.assertTrue((boolean)out.isRouterExternal());
    }

    @Path(value="/getShouldSucceed")
    @POST
    public void getShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackNeutronNetworkResource.getShouldSucceed()");
        String uri = String.format(URI_FORMAT, "get");
        Network out = (Network)this.template.requestBodyAndHeader(uri, null, "ID", (Object)NETWORK_ID, Network.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)NETWORK_NAME, (Object)out.getName());
        Assertions.assertEquals((Object)State.ACTIVE, (Object)out.getStatus());
        Assertions.assertFalse((boolean)out.isRouterExternal());
    }

    @Path(value="/getAllShouldSucceed")
    @POST
    public void getAllShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackNeutronNetworkResource.getAllShouldSucceed()");
        String uri = String.format(URI_FORMAT, "getAll");
        Network[] networks = (Network[])this.template.requestBody(uri, null, Network[].class);
        Assertions.assertNotNull((Object)networks);
        Assertions.assertEquals((int)1, (int)networks.length);
        Assertions.assertEquals((Object)NETWORK_NAME, (Object)networks[0].getName());
        Assertions.assertNotNull((Object)networks[0].getSubnets());
        Assertions.assertEquals((int)1, (int)networks[0].getSubnets().size());
        Assertions.assertEquals((Object)"0c4faf33-8c23-4dc9-8bf5-30dd1ab452f9", networks[0].getSubnets().get(0));
        Assertions.assertEquals((Object)"73f6f1ac-5e58-4801-88c3-7e12c6ddfb39", (Object)networks[0].getId());
        Assertions.assertEquals((Object)NetworkType.VXLAN, (Object)networks[0].getNetworkType());
    }

    @Path(value="/deleteShouldSucceed")
    @POST
    public void deleteShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackNeutronNetworkResource.deleteShouldSucceed()");
        String uri = String.format(URI_FORMAT, "delete");
        this.template.requestBodyAndHeader(uri, null, "ID", (Object)NETWORK_ID);
    }
}

