/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openstack.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.HashMap;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.openstack4j.api.Builders;
import org.openstack4j.model.identity.v3.Group;

@Path(value="/openstack/keystone/groups/")
@ApplicationScoped
public class OpenstackKeystoneGroupResource {
    private static final Logger LOG = Logger.getLogger(OpenstackKeystoneGroupResource.class);
    private static final String URI_FORMAT = "openstack-keystone://{{camel.openstack.test.host-url}}?username=user&password=secret&project=project&operation=%s&subsystem=groups";
    private static final String GROUP_NAME = "GROUP_CRUD";
    private static final String GROUP_ID = "c0d675eac29945ad9dfd08aa1bb75751";
    private static final String GROUP_DOMAIN_ID = "default";
    private static final String GROUP_DESCRIPTION = "Group used for CRUD tests";
    private static final String GROUP_DESCRIPTION_UPDATED = "An updated group used for CRUD tests";
    @Inject
    ProducerTemplate template;

    @Path(value="/createShouldSucceed")
    @POST
    public void createShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneGroupResource.createShouldSucceed()");
        Group in = (Group)Builders.group().name(GROUP_NAME).description(GROUP_DESCRIPTION).domainId(GROUP_DOMAIN_ID).build();
        String uri = String.format(URI_FORMAT, "create");
        Group out = (Group)this.template.requestBody(uri, (Object)in, Group.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)GROUP_NAME, (Object)out.getName());
        Assertions.assertEquals((Object)GROUP_DOMAIN_ID, (Object)out.getDomainId());
        Assertions.assertEquals((Object)GROUP_DESCRIPTION, (Object)out.getDescription());
    }

    @Path(value="/getShouldSucceed")
    @POST
    public void getShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneGroupResource.getShouldSucceed()");
        String uri = String.format(URI_FORMAT, "get");
        Group out = (Group)this.template.requestBodyAndHeader(uri, null, "ID", (Object)GROUP_ID, Group.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)GROUP_NAME, (Object)out.getName());
        Assertions.assertEquals((Object)GROUP_ID, (Object)out.getId());
        Assertions.assertEquals((Object)GROUP_DOMAIN_ID, (Object)out.getDomainId());
        Assertions.assertEquals((Object)GROUP_DESCRIPTION, (Object)out.getDescription());
    }

    @Path(value="/getAllShouldSucceed")
    @POST
    public void getAllShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneGroupResource.getAllShouldSucceed()");
        String uri = String.format(URI_FORMAT, "getAll");
        Group[] groups = (Group[])this.template.requestBody(uri, null, Group[].class);
        Assertions.assertEquals((int)5, (int)groups.length);
        Assertions.assertEquals((Object)"7261c982051c4080a69a52117a861d64", (Object)groups[0].getId());
        Assertions.assertEquals((Object)GROUP_DOMAIN_ID, (Object)groups[1].getDomainId());
        Assertions.assertEquals((Object)"Group for CRUD tests", (Object)groups[2].getDescription());
        Assertions.assertEquals((Object)"role_crud_group", (Object)groups[3].getName());
        Assertions.assertNotNull((Object)groups[4].getLinks());
        Assertions.assertTrue((boolean)groups[4].getLinks().containsKey("self"));
    }

    @Path(value="/updateShouldSucceed")
    @POST
    public void updateShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneGroupResource.updateShouldSucceed()");
        Group in = (Group)Builders.group().id(GROUP_ID).description(GROUP_DESCRIPTION_UPDATED).build();
        String uri = String.format(URI_FORMAT, "update");
        Group out = (Group)this.template.requestBody(uri, (Object)in, Group.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)GROUP_NAME, (Object)out.getName());
        Assertions.assertEquals((Object)GROUP_ID, (Object)out.getId());
        Assertions.assertEquals((Object)GROUP_DESCRIPTION_UPDATED, (Object)out.getDescription());
    }

    @Path(value="/deleteShouldSucceed")
    @POST
    public void deleteShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneGroupResource.deleteShouldSucceed()");
        String uri = String.format(URI_FORMAT, "delete");
        this.template.requestBodyAndHeader(uri, null, "ID", (Object)GROUP_ID);
    }

    @Path(value="/addUserToGroupShouldSucceed")
    @POST
    public void addUserToGroupShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneGroupResource.addUserToGroupShouldSucceed()");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("userId", "d599b83141fc47bc9c25e89267aa27c4");
        headers.put("groupId", "851398fccda34f208e1839ebbc1251d1");
        String uri = String.format(URI_FORMAT, "addUserToGroup");
        this.template.requestBodyAndHeaders(uri, null, headers, Group.class);
    }

    @Path(value="/checkUserGroupShouldSucceed")
    @POST
    public void checkUserGroupShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneGroupResource.checkUserGroupShouldSucceed()");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("userId", "d599b83141fc47bc9c25e89267aa27c4");
        headers.put("groupId", "851398fccda34f208e1839ebbc1251d1");
        String uri = String.format(URI_FORMAT, "checkUserGroup");
        boolean userInGroup = (Boolean)this.template.requestBodyAndHeaders(uri, null, headers, Boolean.class);
        Assertions.assertTrue((boolean)userInGroup);
    }

    @Path(value="/removeUserFromGroupShouldSucceed")
    @POST
    public void removeUserFromGroupShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackKeystoneGroupResource.removeUserFromGroupShouldSucceed()");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("userId", "d599b83141fc47bc9c25e89267aa27c4");
        headers.put("groupId", "851398fccda34f208e1839ebbc1251d1");
        String uri = String.format(URI_FORMAT, "removeUserFromGroup");
        this.template.requestBodyAndHeaders(uri, null, headers);
    }
}

