/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openstack.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.openstack4j.model.storage.block.VolumeSnapshot;

@Path(value="/openstack/cinder/snapshots/")
@ApplicationScoped
public class OpenstackCinderSnapshotResource {
    private static final Logger LOG = Logger.getLogger(OpenstackCinderSnapshotResource.class);
    private static final String URI_FORMAT = "openstack-cinder://{{camel.openstack.test.host-url}}?username=user&password=secret&project=project&operation=%s&subsystem=snapshots";
    @Inject
    ProducerTemplate template;

    @Path(value="/getAllShouldSucceed")
    @POST
    public void getAllShouldSucceed() {
        LOG.debug((Object)"Calling OpenstackCinderSnapshotResource.getAllShouldSucceed()");
        String uri = String.format(URI_FORMAT, "getAll");
        VolumeSnapshot[] volumeSnapshots = (VolumeSnapshot[])this.template.requestBody(uri, null, VolumeSnapshot[].class);
        Assertions.assertEquals((int)2, (int)volumeSnapshots.length);
        Assertions.assertEquals((Object)"a06b0531-c14b-4a7b-8749-de1378dd1007", (Object)volumeSnapshots[0].getId());
        Assertions.assertEquals((Object)"b0e394e6-bb10-4bfe-960d-edf72100c810", (Object)volumeSnapshots[0].getVolumeId());
        Assertions.assertNotNull((Object)volumeSnapshots[0].getMetaData());
        Assertions.assertTrue((boolean)volumeSnapshots[0].getMetaData().isEmpty());
        Assertions.assertEquals((Object)"6489c55f-b9f4-442e-8d0a-5a87349d2d07", (Object)volumeSnapshots[1].getId());
        Assertions.assertEquals((Object)"7f47ab73-303c-4a19-b311-6123bb115775", (Object)volumeSnapshots[1].getVolumeId());
    }
}

