/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openapijava.it.v3;

import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.openapijava.it.OpenApiContentType;
import org.apache.camel.quarkus.component.openapijava.it.common.OpenApiTest;
import org.apache.camel.quarkus.component.openapijava.it.v3.OpenApiV3TestProfile;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

@QuarkusTest
@TestProfile(value=OpenApiV3TestProfile.class)
public class OpenApiV3Test
extends OpenApiTest {
    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiBearerAuthSecurityDefinition(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("components.securitySchemes", Matchers.hasKey((Object)"bearerAuth"), new Object[]{"components.securitySchemes.bearerAuth.scheme", Matchers.is((Object)"bearer"), "components.securitySchemes.bearerAuth.type", Matchers.is((Object)"http"), "components.securitySchemes.bearerAuth.bearerFormat", Matchers.is((Object)"Bearer Token Authentication")});
    }

    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiMutualTlsSecurityDefinition(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("components.securitySchemes", Matchers.hasKey((Object)"mutualTLS"), new Object[]{"components.securitySchemes.mutualTLS.type", Matchers.is((Object)"mutualTLS")});
    }

    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiOpenIdSecurityDefinition(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("components.securitySchemes", Matchers.hasKey((Object)"openId"), new Object[]{"components.securitySchemes.openId.openIdConnectUrl", Matchers.is((Object)"https://secure.apache.org/fake/openid-configuration"), "components.securitySchemes.openId.type", Matchers.is((Object)"openIdConnect")});
    }

    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiServers(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("servers[0].url", Matchers.is((Object)"http://localhost:8080/api"), new Object[0]);
    }

    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiComponents(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("components.schemas.Fruit.type", Matchers.is((Object)"object"), new Object[]{"components.schemas.Fruit.properties.name.type", Matchers.is((Object)"string"), "components.schemas.Fruit.properties.description.type", Matchers.is((Object)"string"), "components.schemas.Fruit.properties.num.type", Matchers.is((Object)"integer"), "components.schemas.Fruit", Matchers.not((Matcher)Matchers.hasKey((Object)"extensions")), "components.schemas.Fruit", Matchers.not((Matcher)Matchers.hasKey((Object)"exampleSetFlag")), "components.schemas.Fruit", Matchers.not((Matcher)Matchers.hasKey((Object)"types")), "components.schemas.Fruit", Matchers.not((Matcher)Matchers.hasKey((Object)"jsonSchema"))});
    }

    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiOneOf(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("components.schemas.XOfFormA.type", Matchers.is((Object)"object"), new Object[]{"components.schemas.XOfFormA.properties.code.type", Matchers.is((Object)"string"), "components.schemas.XOfFormA.properties.a.type", Matchers.is((Object)"string"), "components.schemas.XOfFormA.properties.b.type", Matchers.is((Object)"integer"), "components.schemas.XOfFormA.properties.b.format", Matchers.is((Object)"int32"), "components.schemas.XOfFormB.type", Matchers.is((Object)"object"), "components.schemas.XOfFormB.properties.code.type", Matchers.is((Object)"string"), "components.schemas.XOfFormB.properties.x.type", Matchers.is((Object)"integer"), "components.schemas.XOfFormB.properties.x.format", Matchers.is((Object)"int32"), "components.schemas.XOfFormB.properties.y.type", Matchers.is((Object)"string"), "components.schemas.OneOfForm.oneOf[0].$ref", Matchers.is((Object)"#/components/schemas/XOfFormA"), "components.schemas.OneOfForm.oneOf[1].$ref", Matchers.is((Object)"#/components/schemas/XOfFormB"), "components.schemas.OneOfFormWrapper.type", Matchers.is((Object)"object"), "components.schemas.OneOfFormWrapper.properties.formType.type", Matchers.is((Object)"string"), "components.schemas.OneOfFormWrapper.properties.form.$ref", Matchers.is((Object)"#/components/schemas/OneOfForm")});
    }

    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiAllOf(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("components.schemas.AllOfForm.allOf[0].$ref", Matchers.is((Object)"#/components/schemas/XOfFormA"), new Object[]{"components.schemas.AllOfForm.allOf[1].$ref", Matchers.is((Object)"#/components/schemas/XOfFormB"), "components.schemas.AllOfFormWrapper.type", Matchers.is((Object)"object"), "components.schemas.AllOfFormWrapper.properties.fullForm.$ref", Matchers.is((Object)"#/components/schemas/AllOfForm")});
    }

    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiAnyOf(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("components.schemas.AnyOfForm.anyOf[0].$ref", Matchers.is((Object)"#/components/schemas/XOfFormA"), new Object[]{"components.schemas.AnyOfForm.anyOf[1].$ref", Matchers.is((Object)"#/components/schemas/XOfFormB"), "components.schemas.AnyOfFormWrapper.type", Matchers.is((Object)"object"), "components.schemas.AnyOfFormWrapper.properties.formElements.$ref", Matchers.is((Object)"#/components/schemas/AnyOfForm")});
    }

    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void arrayTypes(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("paths.'/api/operation/spec/array/params'.get.parameters[0].name", Matchers.is((Object)"string_array"), new Object[]{"paths.'/api/operation/spec/array/params'.get.parameters[0].schema.type", Matchers.is((Object)"array"), "paths.'/api/operation/spec/array/params'.get.parameters[0].schema.enum", Matchers.contains((Object[])new String[]{"A", "B", "C"}), "paths.'/api/operation/spec/array/params'.get.parameters[1].name", Matchers.is((Object)"int_array"), "paths.'/api/operation/spec/array/params'.get.parameters[1].schema.type", Matchers.is((Object)"array"), "paths.'/api/operation/spec/array/params'.get.parameters[1].schema.enum", Matchers.contains((Object[])new Integer[]{1, 2, 3}), "paths.'/api/operation/spec/array/params'.get.parameters[2].name", Matchers.is((Object)"integer_array"), "paths.'/api/operation/spec/array/params'.get.parameters[2].schema.type", Matchers.is((Object)"array"), "paths.'/api/operation/spec/array/params'.get.parameters[2].schema.enum", Matchers.contains((Object[])new Integer[]{1, 2, 3}), "paths.'/api/operation/spec/array/params'.get.parameters[3].name", Matchers.is((Object)"long_array"), "paths.'/api/operation/spec/array/params'.get.parameters[3].schema.type", Matchers.is((Object)"array"), "paths.'/api/operation/spec/array/params'.get.parameters[3].schema.enum", Matchers.contains((Object[])new Integer[]{1, 2, 3}), "paths.'/api/operation/spec/array/params'.get.parameters[4].name", Matchers.is((Object)"float_array"), "paths.'/api/operation/spec/array/params'.get.parameters[4].schema.type", Matchers.is((Object)"array"), "paths.'/api/operation/spec/array/params'.get.parameters[4].schema.enum", Matchers.contains((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)}), "paths.'/api/operation/spec/array/params'.get.parameters[5].name", Matchers.is((Object)"double_array"), "paths.'/api/operation/spec/array/params'.get.parameters[5].schema.type", Matchers.is((Object)"array"), "paths.'/api/operation/spec/array/params'.get.parameters[5].schema.enum", Matchers.contains((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)}), "paths.'/api/operation/spec/array/params'.get.parameters[6].name", Matchers.is((Object)"boolean_array"), "paths.'/api/operation/spec/array/params'.get.parameters[6].schema.type", Matchers.is((Object)"array"), "paths.'/api/operation/spec/array/params'.get.parameters[6].schema.enum", Matchers.contains((Object[])new Boolean[]{true, false}), "paths.'/api/operation/spec/array/params'.get.parameters[7].name", Matchers.is((Object)"byte_array"), "paths.'/api/operation/spec/array/params'.get.parameters[7].schema.type", Matchers.is((Object)"array"), "paths.'/api/operation/spec/array/params'.get.parameters[7].schema.enum", Matchers.contains((Object[])new String[]{"MQ==", "Mg==", "Mw=="}), "paths.'/api/operation/spec/array/params'.get.parameters[8].name", Matchers.is((Object)"binary_array"), "paths.'/api/operation/spec/array/params'.get.parameters[8].schema.type", Matchers.is((Object)"array"), "paths.'/api/operation/spec/array/params'.get.parameters[8].schema.enum", Matchers.contains((Object[])new String[]{"MQ==", "Mg==", "Mw=="}), "paths.'/api/operation/spec/array/params'.get.parameters[9].name", Matchers.is((Object)"date_array"), "paths.'/api/operation/spec/array/params'.get.parameters[9].schema.type", Matchers.is((Object)"array"), "paths.'/api/operation/spec/array/params'.get.parameters[9].schema.enum", Matchers.contains((Object[])new String[]{"2023-01-01", "2023-02-02", "2023-03-03"}), "paths.'/api/operation/spec/array/params'.get.parameters[10].name", Matchers.is((Object)"datetime_array"), "paths.'/api/operation/spec/array/params'.get.parameters[10].schema.type", Matchers.is((Object)"array"), "paths.'/api/operation/spec/array/params'.get.parameters[10].schema.enum", Matchers.contains((Object[])new String[]{"2023-01-01T11:11:11+01:00", "2023-02-02T12:12:12+01:00", "2023-03-03T13:13:13+01:00"}), "paths.'/api/operation/spec/array/params'.get.parameters[11].name", Matchers.is((Object)"password_array"), "paths.'/api/operation/spec/array/params'.get.parameters[11].schema.type", Matchers.is((Object)"array"), "paths.'/api/operation/spec/array/params'.get.parameters[11].schema.enum", Matchers.contains((Object[])new String[]{"foo", "bar", "cheese"})});
    }
}

