/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openapijava.it.v2;

import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.openapijava.it.OpenApiContentType;
import org.apache.camel.quarkus.component.openapijava.it.common.OpenApiTest;
import org.apache.camel.quarkus.component.openapijava.it.v2.OpenApiV2TestProfile;
import org.hamcrest.Matchers;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

@QuarkusTest
@TestProfile(value=OpenApiV2TestProfile.class)
public class OpenApiV2Test
extends OpenApiTest {
    @Override
    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiOperationSpecification(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("paths.'/api/operation/spec'", Matchers.hasKey((Object)"get"), new Object[]{"paths.'/api/operation/spec'.get.parameters[0].name", Matchers.is((Object)"header_number"), "paths.'/api/operation/spec'.get.parameters[0].description", Matchers.is((Object)"Header Param Number"), "paths.'/api/operation/spec'.get.parameters[0].default", Matchers.is((Object)1), "paths.'/api/operation/spec'.get.parameters[0].enum", Matchers.contains((Object[])new Integer[]{1, 2, 3}), "paths.'/api/operation/spec'.get.parameters[0].type", Matchers.is((Object)"integer"), "paths.'/api/operation/spec'.get.parameters[0].in", Matchers.is((Object)"header"), "paths.'/api/operation/spec'.get.parameters[0].required", Matchers.is((Object)true), "paths.'/api/operation/spec'.get.parameters[1].name", Matchers.is((Object)"query_letter"), "paths.'/api/operation/spec'.get.parameters[1].description", Matchers.is((Object)"Query Param Letter"), "paths.'/api/operation/spec'.get.parameters[1].default", Matchers.is((Object)"B"), "paths.'/api/operation/spec'.get.parameters[1].enum", Matchers.contains((Object[])new String[]{"A", "B", "C"}), "paths.'/api/operation/spec'.get.parameters[1].type", Matchers.is((Object)"string"), "paths.'/api/operation/spec'.get.parameters[1].in", Matchers.is((Object)"query"), "paths.'/api/operation/spec'.get.parameters[1].required", Matchers.is((Object)false), "paths.'/api/operation/spec'.get.responses.418.headers.rate.type", Matchers.is((Object)"integer"), "paths.'/api/operation/spec'.get.responses.418.headers.rate.description", Matchers.is((Object)"API Rate Limit"), "paths.'/api/operation/spec'.get.responses.418.description", Matchers.is((Object)"I am a teapot"), "paths.'/api/operation/spec'.get.responses.error.description", Matchers.is((Object)"Response Error")});
    }

    @Override
    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiBasicAuthSecurityDefinition(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("securityDefinitions", Matchers.hasKey((Object)"basicAuth"), new Object[]{"securityDefinitions.basicAuth.type", Matchers.is((Object)"basic"), "securityDefinitions.basicAuth.description", Matchers.is((Object)"Basic Authentication")});
    }

    @Override
    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiKeySecurityDefinition(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("securityDefinitions", Matchers.hasKey((Object)"X-API-Key"), new Object[]{"securityDefinitions.X-API-Key.type", Matchers.is((Object)"apiKey"), "securityDefinitions.X-API-Key.description", Matchers.is((Object)"The API key"), "securityDefinitions.X-API-Key.name", Matchers.is((Object)"X-API-KEY"), "securityDefinitions.X-API-Key.in", Matchers.is((Object)"header")});
    }

    @Override
    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiOauth2SecurityDefinition(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("securityDefinitions", Matchers.hasKey((Object)"oauth2"), new Object[]{"securityDefinitions.oauth2.authorizationUrl", Matchers.is((Object)"https://secure.apache.org/fake/oauth2/authorize"), "securityDefinitions.oauth2.flow", Matchers.is((Object)"implicit"), "securityDefinitions.oauth2.scopes.scope1", Matchers.is((Object)"Scope 1"), "securityDefinitions.oauth2.scopes.scope2", Matchers.is((Object)"Scope 2"), "securityDefinitions.oauth2.scopes.scope3", Matchers.is((Object)"Scope 3")});
    }

    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiDefinition(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("host", Matchers.is((Object)"localhost:8080"), new Object[]{"basePath", Matchers.is((Object)"/api"), "schemes", Matchers.contains((Object[])new String[]{"http", "https"})});
    }

    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiDefinitions(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("definitions.Fruit.type", Matchers.is((Object)"object"), new Object[]{"definitions.Fruit.properties.name.type", Matchers.is((Object)"string"), "definitions.Fruit.properties.description.type", Matchers.is((Object)"string"), "definitions.Fruit.properties.num.type", Matchers.is((Object)"integer")});
    }
}

