/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openapijava.it.common;

import io.restassured.RestAssured;
import io.restassured.filter.Filter;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.openapijava.it.OpenApiContentType;
import org.apache.camel.quarkus.component.openapijava.it.YamlToJsonFilter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public abstract class OpenApiTest {
    @BeforeAll
    public static void beforeAll() {
        RestAssured.filters((Filter)new YamlToJsonFilter(), (Filter[])new Filter[0]);
    }

    @Test
    public void invokeApiEndpoint() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("port", new Object[]{RestAssured.port}).get("/api/fruits/list", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("description", Matchers.containsInAnyOrder((Object[])new String[]{"Winter fruit", "Tropical fruit"}), new Object[]{"name", Matchers.containsInAnyOrder((Object[])new String[]{"Apple", "Pineapple"})});
    }

    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void invokeApiDocumentEndpoint(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("paths.'/api/fruits/list'", Matchers.hasKey((Object)"get"), new Object[]{"paths.'/api/fruits/list'.get.summary", Matchers.is((Object)"Gets a list of fruits"), "paths.'/api/fruits/list'.get.operationId", Matchers.is((Object)"list")});
    }

    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiEndpointSecurity(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("paths.'/api/security/scopes'", Matchers.hasKey((Object)"get"), new Object[]{"paths.'/api/security/scopes'.get.security[0].OAuth2", Matchers.contains((Object[])new String[]{"scope1", "scope2", "scope3"})});
    }

    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiKeySecurityDefinition(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("components.securitySchemes", Matchers.hasKey((Object)"X-API-Key"), new Object[]{"components.securitySchemes.X-API-Key.type", Matchers.is((Object)"apiKey"), "components.securitySchemes.X-API-Key.description", Matchers.is((Object)"The API key"), "components.securitySchemes.X-API-Key.name", Matchers.is((Object)"X-API-KEY"), "components.securitySchemes.X-API-Key.in", Matchers.is((Object)"header")});
    }

    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiBasicAuthSecurityDefinition(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("components.securitySchemes", Matchers.hasKey((Object)"basicAuth"), new Object[]{"components.securitySchemes.basicAuth.scheme", Matchers.is((Object)"basic"), "components.securitySchemes.basicAuth.type", Matchers.is((Object)"http"), "components.securitySchemes.basicAuth.description", Matchers.is((Object)"Basic Authentication")});
    }

    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiOauth2SecurityDefinition(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("components.securitySchemes", Matchers.hasKey((Object)"oauth2"), new Object[]{"components.securitySchemes.oauth2.flows.implicit.authorizationUrl", Matchers.is((Object)"https://secure.apache.org/fake/oauth2/authorize"), "components.securitySchemes.oauth2.flows.implicit.scopes.scope1", Matchers.is((Object)"Scope 1"), "components.securitySchemes.oauth2.flows.implicit.scopes.scope2", Matchers.is((Object)"Scope 2"), "components.securitySchemes.oauth2.flows.implicit.scopes.scope3", Matchers.is((Object)"Scope 3")});
    }

    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiOperationSpecification(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("paths.'/api/operation/spec'", Matchers.hasKey((Object)"get"), new Object[]{"paths.'/api/operation/spec'.get.parameters[0].name", Matchers.is((Object)"header_number"), "paths.'/api/operation/spec'.get.parameters[0].description", Matchers.is((Object)"Header Param Number"), "paths.'/api/operation/spec'.get.parameters[0].schema.default", Matchers.is((Object)"1"), "paths.'/api/operation/spec'.get.parameters[0].schema.enum", Matchers.contains((Object[])new String[]{"1", "2", "3"}), "paths.'/api/operation/spec'.get.parameters[0].in", Matchers.is((Object)"header"), "paths.'/api/operation/spec'.get.parameters[0].required", Matchers.is((Object)true), "paths.'/api/operation/spec'.get.parameters[1].name", Matchers.is((Object)"query_letter"), "paths.'/api/operation/spec'.get.parameters[1].description", Matchers.is((Object)"Query Param Letter"), "paths.'/api/operation/spec'.get.parameters[1].schema.default", Matchers.is((Object)"B"), "paths.'/api/operation/spec'.get.parameters[1].schema.enum", Matchers.contains((Object[])new String[]{"A", "B", "C"}), "paths.'/api/operation/spec'.get.parameters[1].in", Matchers.is((Object)"query"), "paths.'/api/operation/spec'.get.parameters[1].required", Matchers.is((Object)false), "paths.'/api/operation/spec'.get.responses.418.headers.rate.description", Matchers.is((Object)"API Rate Limit"), "paths.'/api/operation/spec'.get.responses.418.description", Matchers.is((Object)"I am a teapot"), "paths.'/api/operation/spec'.get.responses.error.description", Matchers.is((Object)"Response Error")});
    }

    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiInfoSpecification(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("info.title", Matchers.is((Object)"Camel Quarkus API"), new Object[]{"info.version", Matchers.is((Object)"1.2.3"), "info.description", Matchers.is((Object)"The Awesome Camel Quarkus REST API"), "info.termsOfService", Matchers.is((Object)"https://camel.apache.org"), "info.contact.name", Matchers.is((Object)"Mr Camel Quarkus"), "info.contact.url", Matchers.is((Object)"https://camel.apache.org"), "info.contact.email", Matchers.is((Object)"mrcq@cq.org"), "info.license.name", Matchers.is((Object)"Apache V2"), "info.license.url", Matchers.is((Object)"https://www.apache.org/licenses/LICENSE-2.0")});
    }

    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiVendorExtensions(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body(Matchers.containsString((String)"x-camelContextId"), new Matcher[0]);
    }

    @Test
    public void testCORSHeaders() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).header("Access-Control-Allow-Headers", Matchers.is((Object)"Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers"))).header("Access-Control-Allow-Methods", Matchers.is((Object)"GET, HEAD, POST, PUT, DELETE, TRACE, OPTIONS, CONNECT, PATCH"))).header("Access-Control-Allow-Origin", Matchers.is((Object)"*"))).header("Access-Control-Max-Age", Matchers.is((Object)"3600"));
    }
}

