/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openapijava.it;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.restassured.builder.ResponseBuilder;
import io.restassured.filter.FilterContext;
import io.restassured.filter.OrderedFilter;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.FilterableResponseSpecification;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jboss.logging.Logger;

public class YamlToJsonFilter
implements OrderedFilter {
    private static final Logger LOG = Logger.getLogger(YamlToJsonFilter.class);

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext ctx) {
        try {
            Response response = ctx.next(requestSpec, responseSpec);
            if (response.getContentType().equals("text/yaml")) {
                String yaml = response.getBody().asString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)yaml);
                }
                ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
                Object obj = yamlReader.readValue(yaml, Object.class);
                ObjectMapper jsonWriter = new ObjectMapper();
                String json = jsonWriter.writeValueAsString(obj);
                ResponseBuilder builder = new ResponseBuilder();
                builder.clone(response);
                builder.setBody(json);
                builder.setContentType(ContentType.JSON);
                return builder.build();
            }
            return response;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to convert the request: " + ExceptionUtils.getMessage((Throwable)e), e);
        }
    }
}

