/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openapijava.it.v3;

import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.openapijava.it.OpenApiContentType;
import org.apache.camel.quarkus.component.openapijava.it.common.OpenApiTest;
import org.apache.camel.quarkus.component.openapijava.it.v3.OpenApiV3TestProfile;
import org.hamcrest.Matchers;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

@QuarkusTest
@TestProfile(value=OpenApiV3TestProfile.class)
public class OpenApiV3Test
extends OpenApiTest {
    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiBearerAuthSecurityDefinition(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("components.securitySchemes", Matchers.hasKey((Object)"bearerAuth"), new Object[]{"components.securitySchemes.bearerAuth.scheme", Matchers.is((Object)"bearer"), "components.securitySchemes.bearerAuth.type", Matchers.is((Object)"http"), "components.securitySchemes.bearerAuth.bearerFormat", Matchers.is((Object)"Bearer Token Authentication")});
    }

    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiMutualTlsSecurityDefinition(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("components.securitySchemes", Matchers.hasKey((Object)"mutualTLS"), new Object[]{"components.securitySchemes.mutualTLS.type", Matchers.is((Object)"mutualTLS")});
    }

    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiOpenIdSecurityDefinition(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("components.securitySchemes", Matchers.hasKey((Object)"openId"), new Object[]{"components.securitySchemes.openId.openIdConnectUrl", Matchers.is((Object)"https://secure.apache.org/fake/openid-configuration"), "components.securitySchemes.openId.type", Matchers.is((Object)"openIdConnect")});
    }

    @ParameterizedTest
    @EnumSource(value=OpenApiContentType.class)
    public void openApiServers(OpenApiContentType contentType) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)contentType.getMimeType(), new Object[0]).get("/openapi", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("servers[0].url", Matchers.is((Object)"http://localhost:8080/api"), new Object[0]);
    }
}

