/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.olingo4.it;

import java.net.URI;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ProducerTemplate;
import org.apache.olingo.client.api.communication.ODataClientErrorException;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientProperty;
import org.apache.olingo.commons.api.http.HttpStatusCode;

@Path(value="/olingo4")
@ApplicationScoped
public class Olingo4Resource {
    public static final String TEST_SERVICE_BASE_URL = "https://services.odata.org/TripPinRESTierService";
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/create")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response create(@QueryParam(value="sessionId") String sessionId, String json) throws Exception {
        ClientEntity entity = (ClientEntity)this.producerTemplate.requestBody("olingo4://create/People?contentType=application/json;charset=utf-8&serviceUri=" + this.getServiceURL(sessionId), (Object)json, ClientEntity.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)entity).build();
    }

    @Path(value="/read")
    @GET
    @Produces(value={"application/json"})
    public Response read(@QueryParam(value="sessionId") String sessionId) {
        Response.ResponseBuilder responseBuilder = Response.status((int)200);
        try {
            String[] fields;
            ClientEntity entity = (ClientEntity)this.producerTemplate.requestBody("olingo4://read/People('lewisblack')?serviceUri=" + this.getServiceURL(sessionId), null, ClientEntity.class);
            JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
            for (String field : fields = new String[]{"FirstName", "LastName", "UserName", "MiddleName"}) {
                ClientProperty property = entity.getProperty(field);
                if (property == null) continue;
                objectBuilder.add(field, property.getPrimitiveValue().toString());
            }
            responseBuilder.entity((Object)objectBuilder.build());
        }
        catch (CamelExecutionException cee) {
            Exception exception = cee.getExchange().getException();
            if (exception instanceof ODataClientErrorException) {
                ODataClientErrorException ex = (ODataClientErrorException)exception;
                responseBuilder.status(ex.getStatusLine().getStatusCode());
            }
            throw cee;
        }
        return responseBuilder.build();
    }

    @Path(value="/update")
    @PATCH
    @Consumes(value={"application/json"})
    public Response update(@QueryParam(value="sessionId") String sessionId, String json) {
        HttpStatusCode status = (HttpStatusCode)this.producerTemplate.requestBody("olingo4://update/People('lewisblack')?serviceUri=" + this.getServiceURL(sessionId), (Object)json, HttpStatusCode.class);
        return Response.status((int)status.getStatusCode()).build();
    }

    @Path(value="/delete")
    @DELETE
    public Response delete(@QueryParam(value="sessionId") String sessionId) {
        HttpStatusCode status = (HttpStatusCode)this.producerTemplate.requestBody("olingo4://delete/People('lewisblack')?serviceUri=" + this.getServiceURL(sessionId), null, HttpStatusCode.class);
        return Response.status((int)status.getStatusCode()).build();
    }

    private String getServiceURL(String sessionId) {
        return String.format("%s/%s/", TEST_SERVICE_BASE_URL, sessionId);
    }
}

