/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.olingo4.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import org.apache.camel.quarkus.component.olingo4.it.Person;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

@QuarkusTest
class Olingo4Test {
    private static String sessionId;

    Olingo4Test() {
    }

    @BeforeAll
    public static void beforeAll() throws IOException {
        sessionId = Olingo4Test.getSession();
    }

    @Test
    public void testOlingo4CrudOperations() {
        Person person = new Person();
        person.setUserName("lewisblack");
        person.setFirstName("Lewis");
        person.setLastName("Black");
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("sessionId", new Object[]{sessionId}).contentType(ContentType.JSON).body((Object)person).post("/olingo4/create", new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("sessionId", new Object[]{sessionId}).body("msg").get("/olingo4/read", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("FirstName", Is.is((Object)person.getFirstName()), new Object[]{"LastName", Is.is((Object)person.getLastName()), "UserName", Is.is((Object)person.getUserName()), "MiddleName", Is.is((Object)"")});
        person.setMiddleName("James");
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("sessionId", new Object[]{sessionId}).contentType(ContentType.JSON).body((Object)person).patch("/olingo4/update", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("sessionId", new Object[]{sessionId}).body("msg").get("/olingo4/read", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("FirstName", Is.is((Object)person.getFirstName()), new Object[]{"LastName", Is.is((Object)person.getLastName()), "UserName", Is.is((Object)person.getUserName()), "MiddleName", Is.is((Object)person.getMiddleName())});
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("sessionId", new Object[]{sessionId}).delete("/olingo4/delete", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("sessionId", new Object[]{sessionId}).body("msg").get("/olingo4/read", new Object[0])).then()).statusCode(404);
    }

    private static String getSession() throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet("https://services.odata.org/TripPinRESTierService");
        BasicHttpContext httpContext = new BasicHttpContext();
        httpClient.execute((HttpUriRequest)httpGet, (HttpContext)httpContext);
        HttpUriRequest currentReq = (HttpUriRequest)httpContext.getAttribute("http.request");
        return currentReq.getURI().getPath().split("/")[2];
    }
}

