/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.nitrite.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.camel.util.CollectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NitriteTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(NitriteTestResource.class);
    private Path dbFile;

    public Map<String, String> start() {
        try {
            String filePrefix = this.getClass().getSimpleName() + "-db-file-";
            LOGGER.debug("Creating temporary file for Nitrite db ({}*)", (Object)filePrefix);
            this.dbFile = Files.createTempFile(filePrefix, "", new FileAttribute[0]);
            return CollectionHelper.mapOf((Object)"camel.quarkus.nitrite.test.db.file", (Object)this.dbFile.toString(), (Object[])new Object[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.dbFile != null) {
                Files.deleteIfExists(this.dbFile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

