/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.nitrite.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.GregorianCalendar;
import org.apache.camel.quarkus.component.nitrite.it.Employee;
import org.apache.camel.quarkus.component.nitrite.it.EmployeeMappable;
import org.apache.camel.quarkus.component.nitrite.it.EmployeeSerializable;
import org.apache.camel.quarkus.component.nitrite.it.NitriteTestResource;
import org.apache.camel.quarkus.component.nitrite.it.Operation;
import org.dizitart.no2.Document;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;

@QuarkusTest
@QuarkusTestResource(value=NitriteTestResource.class)
@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
class NitriteTest {
    private static final EmployeeSerializable sheldonSerializable = new EmployeeSerializable(1L, new GregorianCalendar(2010, 10, 1).getTime(), "Sheldon", "Alpha Centauri");
    private static final EmployeeSerializable leonardSerializable = new EmployeeSerializable(2L, new GregorianCalendar(2015, 10, 1).getTime(), "Leonard", "Earth");
    private static final EmployeeSerializable irmaSerializable = new EmployeeSerializable(3L, new GregorianCalendar(2011, 10, 1).getTime(), "Irma", "Jupiter");
    private static final EmployeeMappable sheldonMappable = new EmployeeMappable(1L, new GregorianCalendar(2010, 10, 1).getTime(), "Sheldon", "Alpha Centauri");
    private static final EmployeeMappable leonardMappable = new EmployeeMappable(2L, new GregorianCalendar(2015, 10, 1).getTime(), "Leonard", "Earth");
    private static final EmployeeMappable irmaMappable = new EmployeeMappable(3L, new GregorianCalendar(2011, 10, 1).getTime(), "Irma", "Jupiter");

    NitriteTest() {
    }

    @Test
    public void repositoryClassSerializable() throws CloneNotSupportedException {
        this.testRepositoryClass((Employee)sheldonSerializable, (Employee)leonardSerializable, (Employee)irmaSerializable);
    }

    @Test
    public void repositoryClassMappable() throws CloneNotSupportedException {
        this.testRepositoryClass((Employee)sheldonMappable, (Employee)leonardMappable, (Employee)irmaMappable);
    }

    private void testRepositoryClass(Employee sheldon, Employee leonard, Employee irma) throws CloneNotSupportedException {
        boolean mappable = sheldon instanceof EmployeeMappable;
        ((ValidatableResponse)RestAssured.get((String)("/nitrite/getRepositoryClass?mappable=" + mappable), (Object[])new Object[0]).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).queryParam("mappable", new Object[]{mappable}).body((Object)sheldon).post("/nitrite/repositoryClass", new Object[0])).then()).statusCode(200)).body("name", Is.is((Object)"Sheldon"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/nitrite/getRepositoryClass?mappable=" + mappable), (Object[])new Object[0]).then()).statusCode(200)).header("CamelNitriteChangeType", "INSERT")).body("name", Is.is((Object)"Sheldon"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).queryParam("mappable", new Object[]{mappable}).body((Object)leonard).post("/nitrite/repositoryClass", new Object[0])).then()).statusCode(200)).body("name", Is.is((Object)"Leonard"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/nitrite/getRepositoryClass?mappable=" + mappable), (Object[])new Object[0]).then()).statusCode(200)).header("CamelNitriteChangeType", "INSERT")).body("name", Is.is((Object)"Leonard"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).queryParam("mappable", new Object[]{mappable}).body((Object)irma).post("/nitrite/repositoryClass", new Object[0])).then()).statusCode(200)).body("name", Is.is((Object)"Irma"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/nitrite/getRepositoryClass?mappable=" + mappable), (Object[])new Object[0]).then()).statusCode(200)).header("CamelNitriteChangeType", "INSERT")).body("name", Is.is((Object)"Irma"), new Object[0]);
        Object updatedSheldon = null;
        updatedSheldon = sheldon instanceof EmployeeSerializable ? (EmployeeSerializable)sheldon.clone() : (EmployeeMappable)sheldon.clone();
        updatedSheldon.setAddress("Moon");
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)new Operation(Operation.Type.update, "name", (Object)"Sheldon", mappable ? null : updatedSheldon, mappable ? (EmployeeMappable)updatedSheldon : null)).queryParam("mappable", new Object[]{mappable}).post("/nitrite/repositoryClassOperation", new Object[0])).then()).body("name", Is.is((Object)"Sheldon"), new Object[]{"address", Is.is((Object)"Moon")});
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/nitrite/getRepositoryClass?mappable=" + mappable), (Object[])new Object[0]).then()).statusCode(200)).header("CamelNitriteChangeType", "UPDATE")).body("name", Is.is((Object)"Sheldon"), new Object[]{"address", Is.is((Object)"Moon")});
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)new Operation(Operation.Type.find, "address", (Object)"Moon", null, null)).queryParam("mappable", new Object[]{mappable}).post("/nitrite/repositoryClassOperation", new Object[0])).then()).statusCode(200)).body("size()", Is.is((Object)1), new Object[]{"[0].name", Is.is((Object)"Sheldon")});
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)new Operation(Operation.Type.findGt, "empId", (Object)0, null, null)).queryParam("mappable", new Object[]{mappable}).post("/nitrite/repositoryClassOperation", new Object[0])).then()).statusCode(200)).body("size()", Is.is((Object)3), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)new Operation(Operation.Type.delete, "address", (Object)"Moon", null, null)).queryParam("mappable", new Object[]{mappable}).post("/nitrite/repositoryClassOperation", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/nitrite/getRepositoryClass?mappable=" + mappable), (Object[])new Object[0]).then()).statusCode(200)).header("CamelNitriteChangeType", "REMOVE")).body("name", Is.is((Object)"Sheldon"), new Object[]{"address", Is.is((Object)"Moon")});
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)new Operation(Operation.Type.findGt, "empId", (Object)0, null, null)).queryParam("mappable", new Object[]{mappable}).post("/nitrite/repositoryClassOperation", new Object[0])).then()).statusCode(200)).body("size()", Is.is((Object)2), new Object[0]);
    }

    @Test
    public void collection() throws Exception {
        ((ValidatableResponse)RestAssured.get((String)"/nitrite/collection", (Object[])new Object[0]).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)Document.createDocument((String)"key1", (Object)"value1")).post("/nitrite/collection", new Object[0])).then()).statusCode(200)).body("key1", Is.is((Object)"value1"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/nitrite/collection", (Object[])new Object[0]).then()).statusCode(200)).header("CamelNitriteChangeType", "INSERT")).body("key1", Is.is((Object)"value1"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)Document.createDocument((String)"key2", (Object)"value2")).post("/nitrite/collection", new Object[0])).then()).statusCode(200)).body("key2", Is.is((Object)"value2"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/nitrite/collection", (Object[])new Object[0]).then()).statusCode(200)).header("CamelNitriteChangeType", "INSERT")).body("key2", Is.is((Object)"value2"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)new Operation(Operation.Type.insert, null, null, Document.createDocument((String)"key1", (Object)"value_beforeUpdate"))).post("/nitrite/collectionOperation", new Object[0])).then()).statusCode(200)).body("key1", Is.is((Object)"value_beforeUpdate"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/nitrite/collection", (Object[])new Object[0]).then()).statusCode(200)).header("CamelNitriteChangeType", "INSERT")).body("key1", Is.is((Object)"value_beforeUpdate"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)new Operation(Operation.Type.update, "key1", (Object)"value_beforeUpdate", Document.createDocument((String)"key1", (Object)"value_afterUpdate"))).post("/nitrite/collectionOperation", new Object[0])).then()).statusCode(200)).body("key1", Is.is((Object)"value_afterUpdate"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/nitrite/collection", (Object[])new Object[0]).then()).statusCode(200)).header("CamelNitriteChangeType", "UPDATE")).body("key1", Is.is((Object)"value_afterUpdate"), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)new Operation(Operation.Type.delete, "key1", (Object)"value1", (Document)null)).post("/nitrite/collectionOperation", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/nitrite/collection", (Object[])new Object[0]).then()).statusCode(200)).header("CamelNitriteChangeType", "REMOVE")).body("key1", Is.is((Object)"value1"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)new Operation(Operation.Type.find, "key1", (Object)"value_afterUpdate", null)).post("/nitrite/collectionOperation", new Object[0])).then()).statusCode(200)).body("size()", Is.is((Object)1), new Object[0]);
    }
}

