/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.netty.udp;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.smallrye.certs.Format;
import io.smallrye.certs.junit5.Certificate;
import java.io.IOException;
import org.apache.camel.quarkus.component.netty.udp.NettyUdpTestResource;
import org.apache.camel.quarkus.test.support.certificate.TestCertificates;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@TestCertificates(certificates={@Certificate(name="netty", formats={Format.PKCS12}, password="changeit")})
@QuarkusTest
@QuarkusTestResource(value=NettyUdpTestResource.class)
class NettyUdpTest {
    NettyUdpTest() {
    }

    @Test
    public void testNettyUdpProduceConsumeWithCodec() throws IOException {
        String message = "Camel Quarkus Netty Custom Codec";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(message).post("/netty/udp/codec", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello Camel Quarkus Netty Custom Codec UDP"), new Matcher[0]);
    }

    @Test
    public void testNettyUdpProduceConsume() throws IOException {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("Camel Quarkus Netty").post("/netty/udp", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello Camel Quarkus Netty UDP"), new Matcher[0]);
    }

    @Test
    public void testNettyUdpProduceConsumeWithServerInitializerFactory() throws IOException {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("Netty").post("/netty/udp/server/initializer", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello Camel Quarkus Netty UDP Custom Server Initializer"), new Matcher[0]);
    }

    @Test
    public void testNettyUdpProduceConsumeWithClientInitializerFactory() throws IOException {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("Camel Quarkus Netty").post("/netty/udp/client/initializer", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello Camel Quarkus Netty Custom Client Initializer UDP"), new Matcher[0]);
    }

    @Test
    public void testNettyUdpProduceConsumeCustomThreadPools() throws IOException {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("Camel Quarkus Netty").post("/netty/udp/custom/thread/pools", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello Camel Quarkus Netty UDP Custom Worker Group"), new Matcher[0]);
    }

    @Test
    public void testNettyUdpObjectSerialization() throws IOException {
        ((ValidatableResponse)((Response)RestAssured.given().body("Camel Quarkus Netty").post("/netty/udp/object/serialize", new Object[0])).then()).statusCode(204);
    }
}

