/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.netty.tcp;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import me.escoffier.certs.Format;
import me.escoffier.certs.junit5.Certificate;
import org.apache.camel.quarkus.component.netty.tcp.NettyTcpTestResource;
import org.apache.camel.quarkus.test.support.certificate.TestCertificates;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@TestCertificates(certificates={@Certificate(name="netty", formats={Format.PKCS12}, password="changeit")})
@QuarkusTest
@QuarkusTestResource(value=NettyTcpTestResource.class)
class NettyTcpTest {
    NettyTcpTest() {
    }

    @Test
    public void testNettyTcpProduceConsume() throws IOException {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("Camel Quarkus Netty").post("/netty/tcp", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello Camel Quarkus Netty TCP"), new Matcher[0]);
    }

    @Test
    public void testNettyTcpProduceConsumeWithByteBufResponse() throws IOException {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("Camel Quarkus Netty").post("/netty/tcp/bytebuf", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello Camel Quarkus Netty TCP"), new Matcher[0]);
    }

    @Test
    public void testNettyTcpProduceConsumeWithCodec() throws IOException {
        String message = "Camel Quarkus Netty Custom Codec";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(message).post("/netty/tcp/codec", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello Camel Quarkus Netty Custom Codec TCP"), new Matcher[0]);
    }

    @Test
    public void testNettyTcpSSLProduceConsume() throws IOException {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("Camel Quarkus Netty").post("/netty/tcp/ssl", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello Camel Quarkus Netty TCP SSL"), new Matcher[0]);
    }

    @Test
    public void testNettyTcpProduceConsumeWithServerInitializerFactory() throws IOException {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("Netty").post("/netty/tcp/server/initializer", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello Camel Quarkus Netty TCP Custom Server Initializer"), new Matcher[0]);
    }

    @Test
    public void testNettyTcpProduceConsumeWithClientInitializerFactory() throws IOException {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("Camel Quarkus Netty").post("/netty/tcp/client/initializer", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello Camel Quarkus Netty TCP Custom Client Initializer"), new Matcher[0]);
    }

    @Test
    public void testNettyTcpProduceConsumeCustomThreadPools() throws IOException {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("Camel Quarkus Netty").post("/netty/tcp/custom/thread/pools", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello Camel Quarkus Netty TCP Custom Worker Group"), new Matcher[0]);
    }

    @Test
    public void testNettyTcpProduceConsumeCorrelationManager() throws IOException {
        ((ValidatableResponse)((Response)RestAssured.given().post("/netty/tcp/custom/correlation/manager", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void testNettyTcpObjectSerialization() throws IOException {
        ((ValidatableResponse)((Response)RestAssured.given().body("Camel Quarkus Netty").post("/netty/tcp/object/serialize", new Object[0])).then()).statusCode(204);
    }
}

