/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.netty.udp;

import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Message;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.netty.NettyCamelStateCorrelationManager;

@Path(value="/netty/udp")
public class NettyUdpResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;
    @Inject
    CamelContext context;
    @Inject
    NettyCamelStateCorrelationManager correlationManager;

    @POST
    public String sendNettyUdpMessage(String message) {
        return (String)this.producerTemplate.requestBody("netty:udp://localhost:{{camel.netty.test-udp-port}}?sync=true", (Object)message, String.class);
    }

    @Path(value="/codec")
    @POST
    public Object sendNettyUdpMessageWithCodec(String message) {
        this.producerTemplate.sendBody("netty:udp://localhost:{{camel.netty.test-codec-udp-port}}?sync=false&udpByteArrayCodec=true", (Object)message.getBytes(StandardCharsets.UTF_8));
        return this.consumerTemplate.receiveBody("seda:custom-udp-codec", 5000L, String.class);
    }

    @Path(value="/server/initializer")
    @POST
    public String sendNettyUdpMessageWithServerInitializer(String message) {
        return (String)this.producerTemplate.requestBody("netty:udp://localhost:{{camel.netty.test-server-initializer-udp-port}}?sync=true", (Object)message, String.class);
    }

    @Path(value="/client/initializer")
    @POST
    public String sendNettyUdpMessageWithClientInitializer(String message) {
        return (String)this.producerTemplate.requestBody("netty:udp://localhost:{{camel.netty.test-udp-port}}?sync=true&clientInitializerFactory=#clientInitializerFactory", (Object)message, String.class);
    }

    @Path(value="/custom/thread/pools")
    @POST
    public String sendNettyUdpMessageWithCustomThreadPools(String message) {
        return (String)this.producerTemplate.requestBody("netty:udp://localhost:{{camel.netty.test-worker-group-udp-port}}?sync=true&workerGroup=#clientWorkerGroup", (Object)message, String.class);
    }

    @Path(value="/object/serialize")
    @POST
    public void sendNettyTcpMessageWithTransferExchange(String message) throws InterruptedException {
        MockEndpoint mockEndpoint = (MockEndpoint)this.context.getEndpoint("mock:udpObjectResult", MockEndpoint.class);
        mockEndpoint.expectedBodiesReceived(new Object[]{message});
        mockEndpoint.expectedHeaderReceived("foo", (Object)"bar");
        mockEndpoint.expectedPropertyReceived("cheese", (Object)"wine");
        this.producerTemplate.send("netty:udp://localhost:{{camel.netty.test-serialization-udp-port}}?sync=true&transferExchange=true&encoders=#udpObjectEncoder&decoders=#udpObjectDecoder", exchange -> {
            Message in = exchange.getMessage();
            in.setBody((Object)message);
            in.setHeader("foo", (Object)"bar");
            exchange.setProperty("cheese", (Object)"wine");
        });
        mockEndpoint.assertIsSatisfied(5000L);
    }
}

