/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.netty.tcp;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.component.netty.NettyCamelStateCorrelationManager;

@Path(value="/netty/tcp")
public class NettyTcpResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;
    @Inject
    CamelContext context;
    @Inject
    NettyCamelStateCorrelationManager correlationManager;

    @POST
    public String sendNettyTcpMessage(String message) {
        return (String)this.producerTemplate.requestBody("netty:tcp://localhost:{{camel.netty.test-tcp-port}}?textline=true&sync=true", (Object)message, String.class);
    }

    @Path(value="/bytebuf")
    @POST
    public String sendNettyTcpMessageWithByteBufResponse(String message) {
        ByteBuf byteBuf = (ByteBuf)this.producerTemplate.requestBody("netty:tcp://localhost:{{camel.netty.test-bytebuf-tcp-port}}?sync=true&useByteBuf=true", (Object)message, ByteBuf.class);
        return byteBuf.toString(StandardCharsets.UTF_8);
    }

    @Path(value="/codec")
    @POST
    public Object sendNettyTcpMessageWithCodec(String message) {
        this.producerTemplate.sendBody("netty:tcp://localhost:{{camel.netty.test-codec-tcp-port}}?disconnect=true&sync=false&allowDefaultCodec=false&decoders=#tcpNullDelimitedHandler,#bytesDecoder&encoders=#bytesEncoder", (Object)this.createNullDelimitedMessage(message));
        return this.consumerTemplate.receiveBody("seda:custom-tcp-codec", 5000L, String.class);
    }

    @Path(value="/ssl")
    @POST
    public String sendNettyTcpSSLMessage(String message) {
        return (String)this.producerTemplate.requestBody("netty:tcp://localhost:{{camel.netty.test-ssl-tcp-port}}?textline=true&sync=true&ssl=true&sslContextParameters=#sslContextParameters", (Object)message, String.class);
    }

    @Path(value="/server/initializer")
    @POST
    public String sendNettyTcpMessageWithServerInitializer(String message) {
        return (String)this.producerTemplate.requestBody("netty:tcp://localhost:{{camel.netty.test-server-initializer-tcp-port}}?sync=true", (Object)message, String.class);
    }

    @Path(value="/client/initializer")
    @POST
    public String sendNettyTcpMessageWithClientInitializer(String message) {
        return (String)this.producerTemplate.requestBody("netty:tcp://localhost:{{camel.netty.test-tcp-port}}?textline=true&sync=true&clientInitializerFactory=#clientInitializerFactory", (Object)message, String.class);
    }

    @Path(value="/custom/thread/pools")
    @POST
    public String sendNettyTcpMessageWithCustomThreadPools(String message) {
        return (String)this.producerTemplate.requestBody("netty:tcp://localhost:{{camel.netty.test-worker-group-tcp-port}}?textline=true&sync=true&workerGroup=#clientWorkerGroup", (Object)message, String.class);
    }

    @Path(value="/custom/correlation/manager")
    @POST
    public void sendNettyTcpMessageWithCustomCorrelationManager() throws InterruptedException {
        MockEndpoint mockEndpoint = (MockEndpoint)this.context.getEndpoint("mock:correlationManagerTcp", MockEndpoint.class);
        mockEndpoint.expectedBodiesReceivedInAnyOrder(new Object[]{"Bye A", "Bye B", "Bye C"});
        ((MockValueBuilder)mockEndpoint.allMessages().header("manager")).isEqualTo((Object)this.correlationManager);
        mockEndpoint.allMessages().predicate(exchange -> {
            String request = (String)exchange.getMessage().getHeader("request", String.class);
            String reply = (String)exchange.getMessage().getBody(String.class);
            return reply.endsWith(request);
        });
        this.producerTemplate.sendBodyAndHeader("seda:correlationManagerTcp", (Object)"A", "request", (Object)"A");
        this.producerTemplate.sendBodyAndHeader("seda:correlationManagerTcp", (Object)"B", "request", (Object)"B");
        this.producerTemplate.sendBodyAndHeader("seda:correlationManagerTcp", (Object)"C", "request", (Object)"C");
        mockEndpoint.assertIsSatisfied(5000L);
    }

    @Path(value="/object/serialize")
    @POST
    public void sendNettyTcpMessageWithTransferExchange(final String message) throws InterruptedException {
        MockEndpoint mockEndpoint = (MockEndpoint)this.context.getEndpoint("mock:tcpObjectResult", MockEndpoint.class);
        mockEndpoint.expectedBodiesReceived(new Object[]{message});
        mockEndpoint.expectedHeaderReceived("foo", (Object)"bar");
        mockEndpoint.expectedPropertyReceived("cheese", (Object)"wine");
        this.producerTemplate.send("netty:tcp://localhost:{{camel.netty.test-serialization-tcp-port}}?sync=true&transferExchange=true&encoders=#tcpObjectEncoder&decoders=#tcpObjectDecoder", new Processor(){

            public void process(Exchange exchange) throws Exception {
                Message in = exchange.getMessage();
                in.setBody((Object)message);
                in.setHeader("foo", (Object)"bar");
                exchange.setProperty("cheese", (Object)"wine");
            }
        });
        mockEndpoint.assertIsSatisfied(5000L);
    }

    private byte[] createNullDelimitedMessage(String message) {
        byte[] messageBytes = message.getBytes(StandardCharsets.UTF_8);
        byte[] bytes = new byte[messageBytes.length + 2];
        bytes[message.length() - 1] = 0;
        bytes[message.length() - 2] = 0;
        for (int i = 0; i < messageBytes.length; ++i) {
            bytes[i] = messageBytes[i];
        }
        return bytes;
    }
}

