/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.netty;

import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;

@Path(value="/netty")
public class NettyResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    @Path(value="/tcp")
    @POST
    public String sendNettyTcpMessage(String message) {
        return (String)this.producerTemplate.requestBody("netty:tcp://localhost:{{camel.netty.test-tcp-port}}?textline=true&sync=true", (Object)message, String.class);
    }

    @Path(value="/udp")
    @POST
    public String sendNettyUdpMessage(String message) {
        return (String)this.producerTemplate.requestBody("netty:udp://localhost:{{camel.netty.test-udp-port}}?sync=true", (Object)message, String.class);
    }

    @Path(value="/tcp/codec")
    @POST
    public Object sendNettyTcpMessageWithCodec(String message) {
        this.producerTemplate.sendBody("netty:tcp://localhost:{{camel.netty.test-codec-tcp-port}}?disconnect=true&sync=false&allowDefaultCodec=false&decoders=#tcpNullDelimitedHandler,#bytesDecoder&encoders=#bytesEncoder", (Object)this.createNullDelimitedMessage(message));
        return this.consumerTemplate.receiveBody("seda:custom-tcp-codec", 5000L, String.class);
    }

    @Path(value="/udp/codec")
    @POST
    public Object sendNettyUdpMessageWithCodec(String message) {
        this.producerTemplate.sendBody("netty:udp://localhost:{{camel.netty.test-codec-udp-port}}?sync=false&udpByteArrayCodec=true", (Object)message.getBytes(StandardCharsets.UTF_8));
        return this.consumerTemplate.receiveBody("seda:custom-udp-codec", 5000L, String.class);
    }

    private byte[] createNullDelimitedMessage(String message) {
        byte[] messageBytes = message.getBytes(StandardCharsets.UTF_8);
        byte[] bytes = new byte[messageBytes.length + 2];
        bytes[message.length() - 1] = 0;
        bytes[message.length() - 2] = 0;
        for (int i = 0; i < messageBytes.length; ++i) {
            bytes[i] = messageBytes[i];
        }
        return bytes;
    }
}

