/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import org.apache.camel.component.netty.ChannelHandlerFactories;
import org.apache.camel.component.netty.ChannelHandlerFactory;

public final class NettyCodecHelper {
    private NettyCodecHelper() {
    }

    public static ChannelHandlerFactory createNullDelimitedHandler(String protocol) {
        ByteBuf delimiter = Unpooled.wrappedBuffer((byte[])new byte[]{0});
        ByteBuf[] delimiters = new ByteBuf[]{delimiter, delimiter};
        return ChannelHandlerFactories.newDelimiterBasedFrameDecoder((int)4096, (ByteBuf[])delimiters, (String)protocol);
    }

    public static BytesDecoder createBytesDecoder() {
        return new BytesDecoder();
    }

    public static BytesEncoder createBytesEncoder() {
        return new BytesEncoder();
    }

    @ChannelHandler.Sharable
    static class BytesEncoder
    extends MessageToMessageEncoder<byte[]> {
        BytesEncoder() {
        }

        protected void encode(ChannelHandlerContext ctx, byte[] msg, List<Object> out) throws Exception {
            byte[] bytes = msg;
            ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(bytes.length);
            buf.writeBytes(bytes);
            out.add(buf);
        }
    }

    @ChannelHandler.Sharable
    static class BytesDecoder
    extends MessageToMessageDecoder<ByteBuf> {
        BytesDecoder() {
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
            if (msg.isReadable()) {
                byte[] bytes = new byte[msg.readableBytes()];
                int readerIndex = msg.readerIndex();
                msg.getBytes(readerIndex, bytes);
                out.add(bytes);
            }
        }
    }
}

