/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.netty;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import org.apache.camel.quarkus.component.netty.NettyTestResource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=NettyTestResource.class)
class NettyTest {
    private static final String POEM = "Epitaph in Kohima, India marking the WWII Battle of Kohima and Imphal, Burma Campaign - Attributed to John Maxwell Edmonds";
    private static final String EXPECTED_RESPONSE = "When You Go Home, Tell Them Of Us And Say, For Your Tomorrow, We Gave Our Today.";

    NettyTest() {
    }

    @Test
    public void testPoem() throws IOException {
        try (Socket socket = new Socket("localhost", (int)Integer.getInteger("camel.netty.test-port"));
             PrintWriter outputWriter = new PrintWriter(socket.getOutputStream(), true);
             BufferedReader inputReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));){
            outputWriter.println(POEM);
            String response = inputReader.readLine();
            Assertions.assertTrue((boolean)response.equalsIgnoreCase(EXPECTED_RESPONSE), (String)"Response did not match expected response");
        }
    }
}

