/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.netty.http;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import org.apache.camel.quarkus.component.netty.http.NettyHttpTestResource;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
@QuarkusTestResource(value=NettyHttpTestResource.class)
public class NettyHttpTest {
    @Test
    public void testExtractHttpRequestFromNettyHttpMessage() {
        String method = "POST";
        String headerName = "testHeaderKey";
        String headerValue = "testHeaderValue";
        String body = "Test body";
        Response response = (Response)RestAssured.when().get("/netty/http/getRequest/{method}/{hName}/{hValue}/{body}", new Object[]{"POST", "testHeaderKey", "testHeaderValue", "Test body"});
        Assertions.assertThat((int)response.getStatusCode()).isEqualTo(200);
        Assertions.assertThat((Object[])response.getBody().print().split(",")).containsAll(List.of("POST", "Test body", "testHeaderKey:testHeaderValue"));
    }

    @Test
    public void testExtractHttpResponseFromNettyHttpMessage() {
        String message = "httpResponseTest";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/netty/http/getResponse/{message}", new Object[]{"httpResponseTest"})).then()).statusCode(200)).body(Matchers.is((Object)"Received message httpResponseTest: OK 200"), new Matcher[0]);
    }

    @ParameterizedTest
    @ValueSource(strings={"wildcard", "wildcard/example.txt"})
    public void testWildcardMatching(String path) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/netty/http/wildcard/{path}", new Object[]{path})).then()).statusCode(200)).body(Matchers.is((Object)"wildcard matched"), new Matcher[0]);
    }

    @Test
    public void testProxy() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/netty/http/proxy", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"proxy"), new Matcher[0]);
    }
}

