/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.netty.http;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.netty.http.NettyHttpTestResource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
@QuarkusTestResource(value=NettyHttpTestResource.class)
public class NettyHttpRestTest {
    @ParameterizedTest
    @ValueSource(strings={"GET", "POST", "PUT", "DELETE"})
    public void testRest(String method) {
        ValidatableResponse response = (ValidatableResponse)((Response)RestAssured.when().get("/netty/http/rest/{method}", new Object[]{method})).then();
        if ("DELETE".equals(method)) {
            response.statusCode(500);
        } else {
            ((ValidatableResponse)response.statusCode(200)).body(Matchers.is((Object)method), new Matcher[0]);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"json", "xml"})
    public void pojoTest(String type) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/netty/http/rest/pojo/{type}", new Object[]{type})).then()).statusCode(200)).body(Matchers.is((Object)"Received: John Doe"), new Matcher[0]);
    }
}

