/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.netty.http;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.camel.quarkus.component.netty.http.NettyHttpTestResource;

public class NettyHttpJaasTestResource
extends NettyHttpTestResource {
    private static final String JAAS_FILE_NAME = "config.jaas";
    private static final Path SOURCE_FILE = Paths.get("src/test/resources/", new String[0]).resolve("config.jaas");
    private static final Path TARGET_FILE = Paths.get("target/", new String[0]).resolve("config.jaas");

    @Override
    public Map<String, String> start() {
        if (!Files.exists(TARGET_FILE, new LinkOption[0])) {
            try {
                Files.copy(SOURCE_FILE, TARGET_FILE, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to copy config.jaas", e);
            }
        }
        System.setProperty("java.security.auth.login.config", TARGET_FILE.toAbsolutePath().toString());
        Map<String, String> properties = super.start();
        properties.put("java.security.auth.login.config", TARGET_FILE.toAbsolutePath().toString());
        return properties;
    }

    @Override
    public void stop() {
        System.clearProperty("java.security.auth.login.config");
        super.stop();
    }
}

