/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.netty.http;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.netty.http.NettyHttpTestResource;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

@QuarkusTest
@QuarkusTestResource(value=NettyHttpTestResource.class)
public class NettyHttpAuthTest {
    @ParameterizedTest
    @CsvSource(value={"null,null,401", "admin,wrongpass,401", "admin,adminpass,200"})
    public void testCredentials(String user, String password, int responseCode) {
        ((ValidatableResponse)((Response)RestAssured.when().get("/netty/http/auth/{path}/{user}/{password}", new Object[]{"auth?securityConfiguration=#securityConfig", user, password})).then()).statusCode(responseCode);
    }

    @ParameterizedTest
    @CsvSource(value={"admin,admin,adminpass,200", "admin,guest,guestpass,401", "admin,null,null,401", "guest,admin,adminpass,200", "guest,guest,guestpass,200", "guest,null,null,401", "wildcard,admin,adminpass,200", "wildcard,guest,guestpass,200", "wildcard,null,null,401", "public,admin,adminpass,200", "public,guest,guestpass,200", "public,null,null,200"})
    public void testAcls(String endpoint, String user, String password, int responseCode) {
        ((ValidatableResponse)((Response)RestAssured.when().get("/netty/http/auth/{path}/{user}/{password}", new Object[]{"acls/" + endpoint + "?securityConfiguration=#acl" + endpoint, user, password})).then()).statusCode(responseCode);
    }
}

