/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.nats.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.Header;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.concurrent.TimeUnit;
import me.escoffier.certs.Format;
import me.escoffier.certs.junit5.Certificate;
import org.apache.camel.quarkus.component.nats.it.NatsTestResource;
import org.apache.camel.quarkus.test.support.certificate.TestCertificates;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;

@TestCertificates(certificates={@Certificate(name="nats", formats={Format.PKCS12, Format.PEM}, password="password")})
@QuarkusTestResource(value=NatsTestResource.class)
@QuarkusTest
class NatsTest {
    NatsTest() {
    }

    @Test
    void basicAuthProduceConsumeRoundTripShouldSucceed() {
        Header header = new Header("sendToEndpointUri", "natsBasicAuth:test");
        ((ValidatableResponse)((Response)RestAssured.given().when().header(header).body("basic-auth-msg").post("/nats/send", new Object[0])).then()).statusCode(204);
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((Response)RestAssured.given().get("/nats/messages/basic-auth", new Object[0])).path("size()", new String[0]).equals(1));
        String[] messages = (String[])((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/nats/messages/basic-auth", new Object[0])).then()).statusCode(200)).extract().as(String[].class);
        Assertions.assertEquals((int)1, (int)messages.length);
        Assertions.assertEquals((Object)"basic-auth-msg", (Object)messages[0]);
    }

    @Test
    void noAuthProduceConsumeRoundTripShouldSucceed() {
        Header header = new Header("sendToEndpointUri", "natsNoAuth:test");
        ((ValidatableResponse)((Response)RestAssured.given().when().header(header).body("no-auth-msg").post("/nats/send", new Object[0])).then()).statusCode(204);
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((Response)RestAssured.given().get("/nats/messages/no-auth", new Object[0])).path("size()", new String[0]).equals(1));
        String[] messages = (String[])((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/nats/messages/no-auth", new Object[0])).then()).statusCode(200)).extract().as(String[].class);
        Assertions.assertEquals((int)1, (int)messages.length);
        Assertions.assertEquals((Object)"no-auth-msg", (Object)messages[0]);
    }

    @Test
    @EnabledIfEnvironmentVariable(named="ENABLE_TLS_TESTS", matches="true")
    void tlsAuthProduceConsumeRoundTripShouldSucceed() {
        Header header = new Header("sendToEndpointUri", "natsTlsAuth:test?sslContextParameters=#ssl&secure=true");
        ((ValidatableResponse)((Response)RestAssured.given().when().header(header).body("tls-auth-msg").post("/nats/send", new Object[0])).then()).statusCode(204);
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((Response)RestAssured.given().get("/nats/messages/tls-auth", new Object[0])).path("size()", new String[0]).equals(1));
        String[] messages = (String[])((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/nats/messages/tls-auth", new Object[0])).then()).statusCode(200)).extract().as(String[].class);
        Assertions.assertEquals((int)1, (int)messages.length);
        Assertions.assertEquals((Object)"tls-auth-msg", (Object)messages[0]);
    }

    @Test
    void tokenAuthProduceConsumeRoundTripShouldSucceed() {
        Header header = new Header("sendToEndpointUri", "natsTokenAuth:test");
        ((ValidatableResponse)((Response)RestAssured.given().when().header(header).body("token-auth-msg").post("/nats/send", new Object[0])).then()).statusCode(204);
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((Response)RestAssured.given().get("/nats/messages/token-auth", new Object[0])).path("size()", new String[0]).equals(1));
        String[] messages = (String[])((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/nats/messages/token-auth", new Object[0])).then()).statusCode(200)).extract().as(String[].class);
        Assertions.assertEquals((int)1, (int)messages.length);
        Assertions.assertEquals((Object)"token-auth-msg", (Object)messages[0]);
    }

    @Test
    void consumeMaxMessagesShouldRetainFirstTwoMessages() {
        Header header = new Header("sendToEndpointUri", "natsNoAuth:max");
        for (int msgNumber = 1; msgNumber <= 10; ++msgNumber) {
            ((ValidatableResponse)((Response)RestAssured.given().when().header(header).body("msg " + msgNumber).post("/nats/send", new Object[0])).then()).statusCode(204);
        }
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((Response)RestAssured.given().get("/nats/messages/2-msg-max", new Object[0])).path("size()", new String[0]).equals(2));
        String[] messages = (String[])((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/nats/messages/2-msg-max", new Object[0])).then()).statusCode(200)).extract().as(String[].class);
        Assertions.assertEquals((int)2, (int)messages.length);
        Assertions.assertEquals((Object)"msg 1", (Object)messages[0]);
        Assertions.assertEquals((Object)"msg 2", (Object)messages[1]);
    }

    @Test
    void consumeMaxQueueMessagesShouldRetainRightNumberOfMessages() {
        Header header = new Header("sendToEndpointUri", "natsNoAuth:qmax");
        for (int msgNumber = 1; msgNumber <= 20; ++msgNumber) {
            ((ValidatableResponse)((Response)RestAssured.given().when().header(header).body("qmsg " + msgNumber).post("/nats/send", new Object[0])).then()).statusCode(204);
        }
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((Response)RestAssured.given().get("/nats/messages/3-qmsg-max", new Object[0])).path("size()", new String[0]).equals(3) && ((Response)RestAssured.given().get("/nats/messages/8-qmsg-max", new Object[0])).path("size()", new String[0]).equals(8));
    }

    @Test
    void requestReplyShouldSucceed() {
        Header header = new Header("sendToEndpointUri", "natsNoAuth:request-reply?replySubject=reply");
        ((ValidatableResponse)((Response)RestAssured.given().when().header(header).body("Request").post("/nats/send", new Object[0])).then()).statusCode(204);
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((Response)RestAssured.given().get("/nats/messages/reply", new Object[0])).path("size()", new String[0]).equals(1));
        String[] messages = (String[])((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/nats/messages/reply", new Object[0])).then()).statusCode(200)).extract().as(String[].class);
        Assertions.assertEquals((int)1, (int)messages.length);
        Assertions.assertEquals((Object)"Request => Reply", (Object)messages[0]);
    }
}

