/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.nats.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.camel.Body;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;

@Path(value="/nats/")
@ApplicationScoped
public class NatsResource {
    private static final Logger LOG = Logger.getLogger(NatsResource.class);
    private final ConcurrentHashMap<String, ConcurrentLinkedQueue<String>> msgStore = new ConcurrentHashMap();
    @Inject
    ProducerTemplate template;

    @Path(value="/send")
    @POST
    @Consumes(value={"text/plain"})
    public void send(@HeaderParam(value="sendToEndpointUri") String sendToEndpointUri, String message) {
        LOG.debugf("Invoking send with (%s, %s)", (Object)sendToEndpointUri, (Object)message);
        this.template.sendBody(sendToEndpointUri, (Object)message);
    }

    void storeMessage(Exchange e, @Body String message) {
        LOG.debugf("Invoking storeMessage with (%s, %s)", (Object)e, (Object)message);
        this.msgStore.computeIfAbsent(e.getFromRouteId(), s -> new ConcurrentLinkedQueue()).add(message);
    }

    @Path(value="/messages/{route-id}")
    @GET
    @Produces(value={"application/json"})
    public Collection<String> getRouteMessages(@PathParam(value="route-id") String routeId) {
        return this.msgStore.get(routeId);
    }
}

