/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.nats.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.quarkus.component.nats.it.NatsResource;
import org.apache.camel.support.jsse.KeyManagersParameters;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.jsse.TrustManagersParameters;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class NatsRoutes
extends RouteBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(NatsRoutes.class);
    @Inject
    NatsResource natsResource;
    @ConfigProperty(name="camel.nats.test.enable-tls")
    boolean tlsTestsEnabled;

    public void configure() {
        this.from("natsBasicAuth:test").routeId("basic-auth").bean((Object)this.natsResource, "storeMessage");
        this.from("natsNoAuth:test").routeId("no-auth").bean((Object)this.natsResource, "storeMessage");
        this.from("natsTokenAuth:test").routeId("token-auth").bean((Object)this.natsResource, "storeMessage");
        if (this.tlsTestsEnabled) {
            LOG.info("TLS tests enabled so starting the TLS auth route");
            String uri = "natsTlsAuth:test?sslContextParameters=#ssl&secure=true";
            this.from("natsTlsAuth:test?sslContextParameters=#ssl&secure=true").routeId("tls-auth").bean((Object)this.natsResource, "storeMessage");
        } else {
            LOG.info("TLS tests NOT enabled, so NOT starting the TLS auth route");
        }
        this.from("natsNoAuth:max?maxMessages=2").routeId("2-msg-max").bean((Object)this.natsResource, "storeMessage");
        String maxMsgUriPattern = "natsNoAuth:qmax?maxMessages=%s&queueName=q";
        this.fromF(maxMsgUriPattern, new Object[]{3}).routeId("3-qmsg-max").bean((Object)this.natsResource, "storeMessage");
        this.fromF(maxMsgUriPattern, new Object[]{8}).routeId("8-qmsg-max").bean((Object)this.natsResource, "storeMessage");
        this.from("natsNoAuth:request-reply").setBody().simple("${body} => Reply");
        this.from("natsNoAuth:reply").routeId("reply").bean((Object)this.natsResource, "storeMessage");
    }

    @Named(value="ssl")
    SSLContextParameters createSSLContextParameters() {
        SSLContextParameters sslContextParameters = new SSLContextParameters();
        KeyManagersParameters keyManagersParameters = new KeyManagersParameters();
        KeyStoreParameters keyStore = new KeyStoreParameters();
        keyStore.setPassword("password");
        keyStore.setResource("certs/nats-keystore.p12");
        keyManagersParameters.setKeyPassword("password");
        keyManagersParameters.setKeyStore(keyStore);
        sslContextParameters.setKeyManagers(keyManagersParameters);
        TrustManagersParameters trustManagersParameters = new TrustManagersParameters();
        KeyStoreParameters trustStore = new KeyStoreParameters();
        trustStore.setPassword("password");
        trustStore.setResource("certs/nats-truststore.p12");
        trustManagersParameters.setKeyStore(trustStore);
        sslContextParameters.setTrustManagers(trustManagersParameters);
        return sslContextParameters;
    }
}

