/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.nats.it;

import io.quarkus.arc.properties.IfBuildProperty;
import jakarta.inject.Named;
import org.apache.camel.component.nats.NatsComponent;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class NatsConfiguration {
    public static final String NATS_BROKER_URL_BASIC_AUTH_CONFIG_KEY = "camel.nats.test.broker-url-basic-auth";
    public static final String NATS_BROKER_URL_NO_AUTH_CONFIG_KEY = "camel.nats.test.broker-url-no-auth";
    public static final String NATS_BROKER_URL_TLS_AUTH_CONFIG_KEY = "camel.nats.test.broker-url-tls-auth";
    public static final String NATS_BROKER_URL_TOKEN_AUTH_CONFIG_KEY = "camel.nats.test.broker-url-token-auth";
    public static final String NATS_ENABLE_TLS_TESTS_CONFIG_KEY = "camel.nats.test.enable-tls";
    @ConfigProperty(name="camel.nats.test.broker-url-basic-auth")
    String natsBasicAuthBrokerUrl;
    @ConfigProperty(name="camel.nats.test.broker-url-no-auth")
    String natsNoAuthBrokerUrl;
    @ConfigProperty(name="camel.nats.test.broker-url-token-auth")
    String natsTokenAuthBrokerUrl;

    @Named
    NatsComponent natsBasicAuth() {
        NatsComponent component = new NatsComponent();
        component.setServers(this.natsBasicAuthBrokerUrl);
        return component;
    }

    @Named
    NatsComponent natsNoAuth() {
        NatsComponent component = new NatsComponent();
        component.setServers(this.natsNoAuthBrokerUrl);
        return component;
    }

    @Named
    @IfBuildProperty(name="camel.nats.test.enable-tls", stringValue="true")
    NatsComponent natsTlsAuth() {
        NatsComponent component = new NatsComponent();
        String natsTlsAuthBrokerUrl = (String)ConfigProvider.getConfig().getValue(NATS_BROKER_URL_TLS_AUTH_CONFIG_KEY, String.class);
        component.setServers(natsTlsAuthBrokerUrl);
        return component;
    }

    @Named
    NatsComponent natsTokenAuth() {
        NatsComponent component = new NatsComponent();
        component.setServers(this.natsTokenAuthBrokerUrl);
        return component;
    }
}

