/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.nats.it;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.camel.Body;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;

@Path(value="/nats/")
@ApplicationScoped
public class NatsResource {
    private static final Logger LOG = Logger.getLogger(NatsResource.class);
    private final ConcurrentHashMap<String, ConcurrentLinkedQueue<String>> msgStore = new ConcurrentHashMap();
    @Inject
    ProducerTemplate template;

    @Path(value="/send")
    @POST
    @Consumes(value={"text/plain"})
    public void send(@HeaderParam(value="sendToEndpointUri") String sendToEndpointUri, String message) {
        LOG.debugf("Invoking send with (%s, %s)", (Object)sendToEndpointUri, (Object)message);
        this.template.sendBody(sendToEndpointUri, (Object)message);
    }

    void storeMessage(Exchange e, @Body String message) {
        LOG.debugf("Invoking storeMessage with (%s, %s)", (Object)e, (Object)message);
        this.msgStore.computeIfAbsent(e.getFromRouteId(), s -> new ConcurrentLinkedQueue()).add(message);
    }

    @Path(value="/messages/{route-id}")
    @GET
    @Produces(value={"application/json"})
    public Collection<String> getRouteMessages(@PathParam(value="route-id") String routeId) {
        return this.msgStore.get(routeId);
    }
}

