/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.nats.it;

import java.util.Map;
import org.apache.camel.quarkus.testcontainers.ContainerResourceLifecycleManager;
import org.apache.camel.util.CollectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;

public class NatsTestResource
implements ContainerResourceLifecycleManager {
    private static final Logger LOG = LoggerFactory.getLogger(NatsTestResource.class);
    private static final String BASIC_AUTH_USERNAME = "admin";
    private static final String BASIC_AUTH_PASSWORD = "password";
    private static final String NATS_IMAGE = "nats:2.1.9";
    private static final int NATS_SERVER_PORT = 4222;
    private static final String TOKEN_AUTH_TOKEN = "!admin23456";
    private GenericContainer basicAuthContainer;
    private GenericContainer noAuthContainer;
    private GenericContainer tlsAuthContainer;
    private GenericContainer tokenAuthContainer;

    public Map<String, String> start() {
        LOG.info(TestcontainersConfiguration.getInstance().toString());
        this.basicAuthContainer = new GenericContainer(NATS_IMAGE).withExposedPorts(new Integer[]{4222}).withCommand(new String[]{"-DV", "--user", BASIC_AUTH_USERNAME, "--pass", BASIC_AUTH_PASSWORD}).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Server is ready.*", (int)1));
        this.basicAuthContainer.start();
        String basicAuthIp = this.basicAuthContainer.getContainerIpAddress();
        Integer basicAuthPort = this.basicAuthContainer.getMappedPort(4222);
        String basicAuthAuthority = "admin:password";
        String basicAuthBrokerUrl = String.format("%s@%s:%d", basicAuthAuthority, basicAuthIp, basicAuthPort);
        this.noAuthContainer = new GenericContainer(NATS_IMAGE).withExposedPorts(new Integer[]{4222}).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Listening for route connections.*", (int)1));
        this.noAuthContainer.start();
        String noAuthIp = this.noAuthContainer.getContainerIpAddress();
        Integer noAuthPort = this.noAuthContainer.getMappedPort(4222);
        String noAuthBrokerUrl = String.format("%s:%s", noAuthIp, noAuthPort);
        this.tlsAuthContainer = new GenericContainer(NATS_IMAGE).withExposedPorts(new Integer[]{4222}).withClasspathResourceMapping("certs/ca.pem", "/certs/ca.pem", BindMode.READ_ONLY).withClasspathResourceMapping("certs/key.pem", "/certs/key.pem", BindMode.READ_ONLY).withClasspathResourceMapping("certs/server.pem", "/certs/server.pem", BindMode.READ_ONLY).withClasspathResourceMapping("conf/tls.conf", "/conf/tls.conf", BindMode.READ_ONLY).withCommand(new String[]{"--config", "/conf/tls.conf", "--tls", "--tlscert=/certs/server.pem", "--tlskey=/certs/key.pem", "--tlsverify", "--tlscacert=/certs/ca.pem"}).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Server is ready.*", (int)1));
        try {
            this.tlsAuthContainer.start();
        }
        catch (Exception ex) {
            throw new RuntimeException("An issue occurred while starting tlsAuthContainer: " + this.tlsAuthContainer.getLogs(), ex);
        }
        String tlsAuthIp = this.tlsAuthContainer.getContainerIpAddress();
        Integer tlsAuthPort = this.tlsAuthContainer.getMappedPort(4222);
        String tlsAuthBrokerUrl = String.format("%s:%d", tlsAuthIp, tlsAuthPort);
        this.tokenAuthContainer = new GenericContainer(NATS_IMAGE).withExposedPorts(new Integer[]{4222}).withCommand(new String[]{"-DV", "-auth", TOKEN_AUTH_TOKEN}).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Server is ready.*", (int)1));
        this.tokenAuthContainer.start();
        String tokenAuthIp = this.tokenAuthContainer.getContainerIpAddress();
        Integer tokenAuthPort = this.tokenAuthContainer.getMappedPort(4222);
        String tokenAuthBrokerUrl = String.format("%s@%s:%d", TOKEN_AUTH_TOKEN, tokenAuthIp, tokenAuthPort);
        Map properties = CollectionHelper.mapOf((Object)"camel.nats.test.broker-url-basic-auth", (Object)basicAuthBrokerUrl, (Object[])new Object[0]);
        properties.put("camel.nats.test.broker-url-no-auth", noAuthBrokerUrl);
        properties.put("camel.nats.test.broker-url-tls-auth", tlsAuthBrokerUrl);
        properties.put("camel.nats.test.broker-url-token-auth", tokenAuthBrokerUrl);
        return properties;
    }

    public void stop() {
        this.stop(this.basicAuthContainer, "natsBasicAuthContainer");
        this.stop(this.noAuthContainer, "natsNoAuthContainer");
        this.stop(this.tlsAuthContainer, "natsTlsAuthContainer");
        this.stop(this.tokenAuthContainer, "natsTokenAuthContainer");
    }

    private void stop(GenericContainer<?> container, String id) {
        try {
            if (container != null) {
                container.stop();
            }
        }
        catch (Exception ex) {
            LOG.error("An issue occured while stopping " + id, (Throwable)ex);
        }
    }
}

