/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mybatis.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.transaction.Transactional;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.quarkus.component.mybatis.it.entity.Account;

@Path(value="/mybatis")
@ApplicationScoped
public class MybatisResource {
    @Inject
    CamelContext context;
    @Inject
    ProducerTemplate template;

    @Path(value="/selectOne")
    @GET
    @Produces(value={"application/json"})
    public Account selectOne(@QueryParam(value="id") Integer id) {
        Account account = (Account)this.template.requestBody("direct:selectOne", (Object)id, Account.class);
        if (account == null) {
            throw new NotFoundException();
        }
        return account;
    }

    @Path(value="/selectList")
    @GET
    @Produces(value={"application/json"})
    public List selectList() {
        return (List)this.template.requestBody("direct:selectList", null, List.class);
    }

    @Path(value="/insertOne")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @Transactional
    public Integer insertOne(Account account) {
        this.template.sendBody("direct:insertOne", (Object)account);
        return this.getCounts();
    }

    @Path(value="/insertList")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @Transactional
    public Integer insertList(List<Account> accounts) {
        this.template.sendBody("direct:insertList", accounts);
        return this.getCounts();
    }

    @Path(value="/deleteOne")
    @DELETE
    @Produces(value={"text/plain"})
    @Transactional
    public Integer deleteOne(@QueryParam(value="id") Integer id) {
        this.template.sendBody("direct:deleteOne", (Object)id);
        return this.getCounts();
    }

    @Path(value="/deleteList")
    @DELETE
    @Produces(value={"text/plain"})
    @Transactional
    public Integer deleteList(List<Integer> ids) {
        this.template.sendBody("direct:deleteList", ids);
        return this.getCounts();
    }

    @Path(value="/updateOne")
    @PATCH
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @Transactional
    public Integer updateOne(Account account) {
        this.template.sendBody("direct:updateOne", (Object)account);
        return this.getCounts();
    }

    @Path(value="/updateList")
    @PATCH
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @Transactional
    public Integer updateList(Map<String, Object> params) {
        this.template.sendBody("direct:updateList", params);
        return this.getCounts();
    }

    private Integer getCounts() {
        return (Integer)this.template.requestBody("mybatis:count?statementType=SelectOne", null, Integer.class);
    }

    @Path(value="/consumer")
    @GET
    @Produces(value={"text/plain"})
    public Integer consumer() throws Exception {
        MockEndpoint results = (MockEndpoint)this.context.getEndpoint("mock:results", MockEndpoint.class);
        results.expectedMessageCount(2);
        this.context.getRouteController().startRoute("mybatis-consumer");
        MockEndpoint.assertIsSatisfied((CamelContext)this.context);
        return results.getReceivedCounter();
    }

    @Path(value="/afterConsumer")
    @GET
    @Produces(value={"application/json"})
    public List afterConsumer() {
        return (List)this.template.requestBody("mybatis:selectProcessedAccounts?statementType=SelectList", null, List.class);
    }
}

