/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mybatis.it;

import jakarta.enterprise.context.ApplicationScoped;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.quarkus.component.mybatis.it.entity.Account;

@ApplicationScoped
public class MyBatisRoute
extends RouteBuilder {
    public void configure() throws Exception {
        this.from("direct:selectOne").to("mybatis:selectAccountById?statementType=SelectOne");
        this.from("direct:selectList").to("mybatis:selectAllAccounts?statementType=SelectList");
        ((TransactedDefinition)this.from("direct:insertOne").transacted().to("mybatis:insertAccount?statementType=Insert")).process(exchange -> {
            Account account = (Account)exchange.getIn().getBody(Account.class);
            if (account.getFirstName().equals("Rollback")) {
                throw new RuntimeException("Rollback");
            }
        });
        this.from("direct:insertList").transacted().to("mybatis:batchInsertAccount?statementType=InsertList");
        this.from("direct:deleteOne").transacted().to("mybatis:deleteAccountById?statementType=Delete");
        this.from("direct:deleteList").transacted().to("mybatis:batchDeleteAccountById?statementType=DeleteList");
        this.from("direct:updateOne").transacted().to("mybatis:updateAccount?statementType=Update");
        this.from("direct:updateList").transacted().to("mybatis:batchUpdateAccount?statementType=UpdateList");
        this.from("mybatis:selectUnprocessedAccounts?onConsume=consumeAccount").routeId("mybatis-consumer").autoStartup(false).to("mock:results");
    }
}

