/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mybatis.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.h2.H2DatabaseTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.camel.quarkus.component.mybatis.it.entity.Account;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=H2DatabaseTestResource.class)
public class MyBatisTest {
    @Test
    public void tests() {
        this.testSelectOne();
        this.testSelectOneNotFound();
        this.testSelectList();
        this.testUpdateOne();
        this.testUpdateList();
        this.testInsert();
        this.testInsertList();
        this.testInsertRollback();
        this.testSelectOneNotFound();
        this.testDelete();
        this.testDeleteNotFound();
        this.testDeleteList();
    }

    public void testSelectOne() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/mybatis/selectOne?id=456", (Object[])new Object[0]).then()).statusCode(200)).body("id", Matchers.equalTo((Object)456), new Object[0])).body("firstName", Matchers.equalTo((Object)"Claus"), new Object[0])).body("lastName", Matchers.equalTo((Object)"Ibsen"), new Object[0])).body("emailAddress", Matchers.equalTo((Object)"Noname@gmail.com"), new Object[0]);
    }

    public void testSelectOneNotFound() {
        ((ValidatableResponse)RestAssured.get((String)"/mybatis/selectOne?id=999", (Object[])new Object[0]).then()).statusCode(404);
    }

    public void testSelectList() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/mybatis/selectList", (Object[])new Object[0]).then()).statusCode(200)).body("size()", Matchers.equalTo((Object)2), new Object[0])).body("[0].id", Matchers.equalTo((Object)123), new Object[0])).body("[0].firstName", Matchers.equalTo((Object)"James"), new Object[0])).body("[0].lastName", Matchers.equalTo((Object)"Strachan"), new Object[0])).body("[0].emailAddress", Matchers.equalTo((Object)"TryGuessing@gmail.com"), new Object[0])).body("[1].id", Matchers.equalTo((Object)456), new Object[0])).body("[1].firstName", Matchers.equalTo((Object)"Claus"), new Object[0])).body("[1].lastName", Matchers.equalTo((Object)"Ibsen"), new Object[0])).body("[1].emailAddress", Matchers.equalTo((Object)"Noname@gmail.com"), new Object[0]);
    }

    public void testInsert() {
        Account account = new Account();
        account.setId(444);
        account.setFirstName("Willem");
        account.setLastName("Jiang");
        account.setEmailAddress("Faraway@gmail.com");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)account).post("/mybatis/insertOne", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"3"), new Matcher[0]);
    }

    public void testInsertRollback() {
        Account account = new Account();
        account.setId(999);
        account.setFirstName("Rollback");
        account.setLastName("Rollback");
        account.setEmailAddress("Rollback@gmail.com");
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)account).post("/mybatis/insertOne", new Object[0])).then()).statusCode(500);
    }

    public void testInsertList() {
        Account account1 = new Account();
        account1.setId(555);
        account1.setFirstName("Aaron");
        account1.setLastName("Daubman");
        account1.setEmailAddress("ReadTheDevList@gmail.com");
        Account account2 = new Account();
        account2.setId(666);
        account2.setFirstName("Amos");
        account2.setLastName("Feng");
        account2.setEmailAddress("ZHENG@gmail.com");
        ArrayList<Account> accountList = new ArrayList<Account>(2);
        accountList.add(account1);
        accountList.add(account2);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(accountList).post("/mybatis/insertList", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"5"), new Matcher[0]);
    }

    public void testUpdateOne() {
        Account account = new Account();
        account.setId(456);
        account.setFirstName("Claus");
        account.setLastName("Ibsen");
        account.setEmailAddress("Other@gmail.com");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)account).patch("/mybatis/updateOne", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"2"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/mybatis/selectOne?id=456", (Object[])new Object[0]).then()).statusCode(200)).body("id", Matchers.equalTo((Object)456), new Object[0])).body("firstName", Matchers.equalTo((Object)"Claus"), new Object[0])).body("lastName", Matchers.equalTo((Object)"Ibsen"), new Object[0])).body("emailAddress", Matchers.equalTo((Object)"Other@gmail.com"), new Object[0]);
    }

    public void testUpdateList() {
        Account account1 = new Account();
        account1.setId(123);
        Account account2 = new Account();
        account2.setId(456);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("list", Arrays.asList(account1, account2));
        params.put("emailAddress", "Update@gmail.com");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(params).patch("/mybatis/updateList", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"2"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/mybatis/selectList", (Object[])new Object[0]).then()).statusCode(200)).body("size()", Matchers.equalTo((Object)2), new Object[0])).body("[0].id", Matchers.equalTo((Object)123), new Object[0])).body("[0].firstName", Matchers.equalTo((Object)"James"), new Object[0])).body("[0].lastName", Matchers.equalTo((Object)"Strachan"), new Object[0])).body("[0].emailAddress", Matchers.equalTo((Object)"Update@gmail.com"), new Object[0])).body("[1].id", Matchers.equalTo((Object)456), new Object[0])).body("[1].firstName", Matchers.equalTo((Object)"Claus"), new Object[0])).body("[1].lastName", Matchers.equalTo((Object)"Ibsen"), new Object[0])).body("[1].emailAddress", Matchers.equalTo((Object)"Update@gmail.com"), new Object[0]);
    }

    public void testDelete() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.delete((String)"/mybatis/deleteOne?id=456", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"4"), new Matcher[0]);
    }

    public void testDeleteNotFound() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.delete((String)"/mybatis/deleteOne?id=999", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"4"), new Matcher[0]);
    }

    public void testDeleteList() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(Arrays.asList(444, 555, 666)).delete("/mybatis/deleteList", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"1"), new Matcher[0]);
    }
}

