/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mybatis.it;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.mybatis.it.entity.Account;

@Path(value="/mybatis")
@ApplicationScoped
public class MybatisResource {
    @Inject
    ProducerTemplate template;

    @Path(value="/selectOne")
    @GET
    @Produces(value={"application/json"})
    public Account selectOne(@QueryParam(value="id") Integer id) {
        Account account = (Account)this.template.requestBody("direct:selectOne", (Object)id, Account.class);
        if (account == null) {
            throw new NotFoundException();
        }
        return account;
    }

    @Path(value="/insertOne")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @Transactional
    public Integer insertOne(Account account) {
        this.template.sendBody("direct:insertOne", (Object)account);
        return this.getCounts();
    }

    @Path(value="/deleteOne")
    @DELETE
    @Produces(value={"text/plain"})
    @Transactional
    public Integer deleteOne(@QueryParam(value="id") Integer id) {
        this.template.sendBody("direct:deleteOne", (Object)id);
        return this.getCounts();
    }

    private Integer getCounts() {
        return (Integer)this.template.requestBody("mybatis:count?statementType=SelectOne", null, Integer.class);
    }
}

