/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mustache.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
class MustacheTest {
    MustacheTest() {
    }

    @Test
    void templateFromClassPathResource() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("FromClassPath").post("/mustache/templateFromClassPathResource", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"\nMessage with body 'FromClassPath' and some header 'value'"), new Matcher[0]);
    }

    @Test
    void templateFromHeader() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("FromHeader").post("/mustache/templateFromHeader", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Body='FromHeader'"), new Matcher[0]);
    }

    @Test
    void templateUriFromHeader() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("UriFromHeader").post("/mustache/templateUriFromHeader", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"\nAnother body 'UriFromHeader'!"), new Matcher[0]);
    }

    @Test
    void templateWithInheritance() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/mustache/templateWithInheritance", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"\n\nStart ContentFrom(Child) End"), new Matcher[0]);
    }

    @Test
    void templateWithPartials() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/mustache/templateWithPartials", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"\nStart-\nIncluded-End"), new Matcher[0]);
    }

    @Test
    void templateFromRegistry() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Entry").post("/mustache/templateFromRegistry", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Begin-FromRegistry-Entry-End"), new Matcher[0]);
    }
}

