/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mongodb.it;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.bson.Document;

@ApplicationScoped
public class MongoDbRoute
extends RouteBuilder {
    public static final String COLLECTION_TAILING = "tailingCollection";
    public static final String COLLECTION_PERSISTENT_TAILING = "persistentTailingCollection";
    public static final String COLLECTION_STREAM_CHANGES = "streamChangesCollection";
    @Inject
    @Named(value="results")
    Map<String, List<Document>> results;

    public void configure() {
        this.from(String.format("mongodb:%s?database=test&collection=%s&tailTrackIncreasingField=increasing", "camelMongoClient", COLLECTION_TAILING)).process(e -> {
            List<Document> list;
            List<Document> list2 = list = this.results.get(COLLECTION_TAILING);
            synchronized (list2) {
                list.add((Document)e.getMessage().getBody(Document.class));
            }
        });
        ((RouteDefinition)this.from(String.format("mongodb:%s?database=test&collection=%s&tailTrackIncreasingField=increasing&persistentTailTracking=true&persistentId=darwin", "camelMongoClient", COLLECTION_PERSISTENT_TAILING)).id(COLLECTION_PERSISTENT_TAILING)).process(e -> {
            List<Document> list;
            List<Document> list2 = list = this.results.get(COLLECTION_PERSISTENT_TAILING);
            synchronized (list2) {
                list.add((Document)e.getMessage().getBody(Document.class));
            }
        });
        this.from(String.format("mongodb:%s?database=test&collection=%s&consumerType=changeStreams&streamFilter=%s", "camelMongoClient", COLLECTION_STREAM_CHANGES, "{'$match':{'$or':[{'fullDocument.string': 'value2'}]}}")).process(e -> {
            List<Document> list;
            List<Document> list2 = list = this.results.get(COLLECTION_STREAM_CHANGES);
            synchronized (list2) {
                list.add((Document)e.getMessage().getBody(Document.class));
            }
        });
    }

    @Produces
    @ApplicationScoped
    @Named(value="results")
    Map<String, List<Document>> results() {
        HashMap<String, List<Document>> result = new HashMap<String, List<Document>>();
        result.put(COLLECTION_TAILING, new LinkedList());
        result.put(COLLECTION_PERSISTENT_TAILING, new LinkedList());
        result.put(COLLECTION_STREAM_CHANGES, new LinkedList());
        return result;
    }
}

