/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mongodb.it;

import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Filters;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.util.CollectionHelper;
import org.bson.Document;
import org.bson.conversions.Bson;

@Path(value="/mongodb")
@ApplicationScoped
public class MongoDbResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    CamelContext camelContext;
    @Inject
    @Named(value="results")
    Map<String, List<Document>> results;

    @POST
    @Path(value="/collection/{collectionName}")
    @Consumes(value={"application/json"})
    public Response writeToCollection(@PathParam(value="collectionName") String collectionName, String content, @HeaderParam(value="mongoClientName") String mongoClientName) throws URISyntaxException {
        this.producerTemplate.sendBody(String.format("mongodb:%s?database=test&collection=%s&operation=insert&dynamicity=true", mongoClientName, collectionName), (Object)content);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @GET
    @Path(value="/collection/{collectionName}")
    @Produces(value={"application/json"})
    public JsonArray getCollection(@PathParam(value="collectionName") String collectionName, @HeaderParam(value="mongoClientName") String mongoClientName) {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        MongoIterable iterable = (MongoIterable)this.producerTemplate.requestBody(String.format("mongodb:%s?database=test&collection=%s&operation=findAll&dynamicity=true&outputType=MongoIterable", mongoClientName, collectionName), null, MongoIterable.class);
        for (Document document : iterable) {
            JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
            objectBuilder.add("message", (String)document.get((Object)"message"));
            arrayBuilder.add((JsonValue)objectBuilder.build());
        }
        return arrayBuilder.build();
    }

    @GET
    @Path(value="/collectionAsList/{collectionName}")
    @Produces(value={"application/json"})
    public List getCollectionAsList(@PathParam(value="collectionName") String collectionName, @HeaderParam(value="mongoClientName") String mongoClientName) {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        List list = (List)this.producerTemplate.requestBody(String.format("mongodb:%s?database=test&collection=%s&operation=findAll&dynamicity=true&outputType=DocumentList", mongoClientName, collectionName), null, List.class);
        return list.stream().map(d -> d.getString((Object)"name")).collect(Collectors.toList());
    }

    @GET
    @Path(value="/searchByNameAsDocument/{collectionName}/{name}")
    @Produces(value={"application/json"})
    public Document searchByNameAsDocument(@PathParam(value="collectionName") String collectionName, @PathParam(value="name") String name, @HeaderParam(value="mongoClientName") String mongoClientName) {
        Bson query = Filters.eq((String)"name", (Object)name);
        return (Document)this.producerTemplate.requestBodyAndHeader(String.format("mongodb:%s?database=test&collection=%s&operation=findOneByQuery&dynamicity=true&outputType=Document", mongoClientName, collectionName), (Object)query, "CamelMongoDbDistinctQueryField", (Object)"name", Document.class);
    }

    @POST
    @Path(value="/collection/dynamic/{collectionName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Object dynamic(@PathParam(value="collectionName") String collectionName, String content, @HeaderParam(value="mongoClientName") String mongoClientName, @HeaderParam(value="dynamicOperation") String operation) throws URISyntaxException {
        Object result = this.producerTemplate.requestBodyAndHeader(String.format("mongodb:%s?database=test&collection=%s&operation=insert&dynamicity=true", mongoClientName, collectionName), (Object)content, "CamelMongoDbOperation", (Object)operation);
        return result;
    }

    @GET
    @Path(value="/route/{routeId}/{operation}")
    @Produces(value={"text/plain"})
    public String restartRoute(@PathParam(value="routeId") String routeId, @PathParam(value="operation") String operation) throws Exception {
        switch (operation) {
            case "stop": {
                this.camelContext.getRouteController().stopRoute(routeId);
                break;
            }
            case "start": {
                this.camelContext.getRouteController().startRoute(routeId);
                break;
            }
            case "status": {
                return this.camelContext.getRouteController().getRouteStatus(routeId).name();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/results/{resultId}")
    @Produces(value={"application/json"})
    public Map getResults(@PathParam(value="resultId") String resultId) {
        List<Document> list;
        List<Document> list2 = list = this.results.get(resultId);
        synchronized (list2) {
            int size = list.size();
            Document last = null;
            if (!list.isEmpty()) {
                last = list.get(size - 1);
            }
            return CollectionHelper.mapOf((Object)"size", (Object)size, (Object[])new Object[]{"last", last});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/resultsReset/{resultId}")
    public void resetResults(@PathParam(value="resultId") String resultId) {
        List<Document> list;
        List<Document> list2 = list = this.results.get(resultId);
        synchronized (list2) {
            if (!list.isEmpty()) {
                list.clear();
            }
        }
    }

    @Path(value="/convertMapToDocument")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Map convertMapToDocument(Map input) {
        Document doc = (Document)this.camelContext.getTypeConverter().convertTo(Document.class, (Object)input);
        doc.put("clazz", (Object)doc.getClass().getName());
        return doc;
    }

    @Path(value="/convertAnyObjectToDocument")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public Map convertMapToDocument(String input) {
        Document doc = (Document)this.camelContext.getTypeConverter().convertTo(Document.class, (Object)new SimplePojo(input));
        doc.put("clazz", (Object)doc.getClass().getName());
        return doc;
    }

    @RegisterForReflection
    private static class SimplePojo {
        private String value;

        public SimplePojo(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

