/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mongodb.it;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ServiceStatus;
import org.apache.camel.quarkus.test.support.mongodb.MongoDbTestResource;
import org.apache.camel.util.CollectionHelper;
import org.awaitility.Awaitility;
import org.bson.Document;
import org.eclipse.microprofile.config.ConfigProvider;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
@QuarkusTestResource(value=MongoDbTestResource.class)
class MongoDbTest {
    private static final Logger LOG = Logger.getLogger(MongoDbTest.class);
    public static final String MSG = "Hello Camel Quarkus Mongo DB";
    private static String COLLECTION_OUTPUT_TYPE_DOCUMENT_LIST = "outputTypeDocumentList";
    private static String COLLECTION_OUTPUT_TYPE_DOCUMENT = "outputTypeDocument";
    private static MongoClient mongoClient;
    private static MongoDatabase db;

    MongoDbTest() {
    }

    @BeforeAll
    public static void setUp() throws SQLException {
        String mongoUrl = "mongodb://" + (String)ConfigProvider.getConfig().getValue("quarkus.mongodb.hosts", String.class);
        if (mongoUrl != null) {
            mongoClient = MongoClients.create((String)mongoUrl);
        }
        db = mongoClient.getDatabase("test");
    }

    @AfterAll
    public static void cleanUp() throws SQLException {
        if (mongoClient != null) {
            mongoClient.close();
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"camelMongoClient", "myMongoClient"})
    public void testMongoDbComponent(String namedClient) {
        String collectionName = String.format("%sCamelTest", namedClient);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{message:\"Hello Camel Quarkus Mongo DB\"}").header("mongoClientName", (Object)namedClient, new Object[0]).post("/mongodb/collection/" + collectionName, new Object[0])).then()).statusCode(201);
        JsonPath jsonPath = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("mongoClientName", (Object)namedClient, new Object[0]).get("/mongodb/collection/" + collectionName, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).extract().body().jsonPath();
        List documents = (List)jsonPath.get();
        Assertions.assertEquals((int)1, (int)documents.size());
        Map document = (Map)documents.get(0);
        Assertions.assertEquals((Object)MSG, document.get("message"));
    }

    @Test
    public void testDynamicOperation() {
        String collectionName = "dynamicCamelTest";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{message:\"Hello Camel Quarkus Mongo DB\"}").header("mongoClientName", (Object)"camelMongoClient", new Object[0]).post("/mongodb/collection/dynamic/" + collectionName, new Object[0])).then()).statusCode(200)).body("message", Matchers.is((Object)MSG), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{message:\"Hello Camel Quarkus Mongo DB\"}").header("mongoClientName", (Object)"camelMongoClient", new Object[0]).header("dynamicOperation", (Object)"count", new Object[0]).post("/mongodb/collection/dynamic/" + collectionName, new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"1"), new Matcher[0]);
    }

    @Test
    public void testTailingConsumer() throws Exception {
        MongoCollection collection = db.getCollection("tailingCollection", Document.class);
        for (int i = 1; i <= 10000; ++i) {
            collection.insertOne((Object)new Document("increasing", (Object)i).append("string", (Object)("value" + i)));
            if (i % 1000 != 0) continue;
            this.waitAndResetTailingResults(1000, "value" + i, "tailingCollection");
        }
    }

    @Test
    public void testPersistentTailingConsumer() throws Exception {
        int i;
        MongoCollection collection = db.getCollection("persistentTailingCollection", Document.class);
        for (i = 1; i <= 3000; ++i) {
            collection.insertOne((Object)new Document("increasing", (Object)i).append("string", (Object)("value" + i)));
            if (i % 1000 != 0) continue;
            this.waitAndResetTailingResults(1000, "value" + i, "persistentTailingCollection");
        }
        this.routeController("persistentTailingCollection", "stop", null);
        this.routeController("persistentTailingCollection", "status", ServiceStatus.Stopped.name());
        this.routeController("persistentTailingCollection", "start", null);
        this.routeController("persistentTailingCollection", "status", ServiceStatus.Started.name());
        for (i = 3001; i <= 6000; ++i) {
            collection.insertOne((Object)new Document("increasing", (Object)i).append("string", (Object)("value" + i)));
            if (i % 1000 != 0) continue;
            this.waitAndResetTailingResults(1000, "value" + i, "persistentTailingCollection");
        }
    }

    private String routeController(String routeId, String operation, String expectedResult) {
        if (expectedResult == null) {
            ((ValidatableResponse)((Response)RestAssured.given().get("/mongodb/route/" + routeId + "/" + operation, new Object[0])).then()).statusCode(204);
        } else {
            Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/mongodb/route/" + routeId + "/" + operation), (Object[])new Object[0]).then()).statusCode(200)).extract().asString(), Matchers.is((Object)expectedResult));
        }
        return null;
    }

    @Test
    public void testStreamConsumerWithFilter() throws Exception {
        MongoCollection collection = db.getCollection("streamChangesCollection", Document.class);
        for (int i = 1; i <= 10; ++i) {
            collection.insertOne((Object)new Document("increasing", (Object)i).append("string", (Object)("value" + i)));
        }
        this.waitAndResetTailingResults(1, "value2", "streamChangesCollection");
    }

    @Test
    public void testConvertMapToDocument() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)CollectionHelper.mapOf((Object)"key1", (Object)"val1", (Object[])new Object[]{"key2", "val2"})).post("/mongodb/convertMapToDocument", new Object[0])).then()).statusCode(200)).body("clazz", Matchers.is((Object)Document.class.getName()), new Object[]{"key1", Matchers.is((Object)"val1"), "key2", Matchers.is((Object)"val2")});
    }

    @Test
    public void testConvertAnyObjectToDocument() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("Hello!").post("/mongodb/convertAnyObjectToDocument", new Object[0])).then()).statusCode(200)).body("clazz", Matchers.is((Object)Document.class.getName()), new Object[]{"value", Matchers.is((Object)"Hello!")});
    }

    @Test
    public void testOutputTypeDocumentList() throws Exception {
        MongoCollection collection = db.getCollection(COLLECTION_OUTPUT_TYPE_DOCUMENT_LIST, Document.class);
        collection.insertOne((Object)new Document("name", (Object)"Sheldon"));
        collection.insertOne((Object)new Document("name", (Object)"Irma"));
        collection.insertOne((Object)new Document("name", (Object)"Leonard"));
        List results = (List)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("mongoClientName", (Object)"camelMongoClient", new Object[0]).get("/mongodb/collectionAsList/" + COLLECTION_OUTPUT_TYPE_DOCUMENT_LIST, new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("size()", Matchers.is((Object)3), new Object[0])).extract().as(List.class);
        Assertions.assertTrue((boolean)results.contains("Sheldon"));
        Assertions.assertTrue((boolean)results.contains("Irma"));
        Assertions.assertTrue((boolean)results.contains("Leonard"));
    }

    @Test
    public void testOutputTypeDocument() throws Exception {
        MongoCollection collection = db.getCollection(COLLECTION_OUTPUT_TYPE_DOCUMENT, Document.class);
        collection.insertOne((Object)new Document("name", (Object)"Sheldon"));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("mongoClientName", (Object)"camelMongoClient", new Object[0]).get("/mongodb/searchByNameAsDocument/" + COLLECTION_OUTPUT_TYPE_DOCUMENT + "/Sheldon", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("name", Matchers.is((Object)"Sheldon"), new Object[]{"_id", Matchers.not((Matcher)Matchers.nullValue())});
    }

    private void waitAndResetTailingResults(int expectedSize, String laststring, String resultId) {
        LOG.info((Object)("Awaiting results with size " + expectedSize + " and last string " + laststring));
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> {
            Map result = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/mongodb/results/" + resultId, new Object[0])).then()).statusCode(200)).extract().as(Map.class);
            LOG.info((Object)("Received results" + result));
            return result;
        }, m -> (Integer)m.get("size") == expectedSize && laststring.equals(((Map)m.get("last")).get("string")));
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/mongodb/resultsReset/" + resultId, new Object[0])).then()).statusCode(204);
    }
}

