/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mongodb.it;

import com.mongodb.MongoGridFSException;
import java.net.URI;
import java.util.HashMap;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;

@Path(value="/mongodb-gridfs")
public class MongodbGridfsResource {
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/upload/{fileName}")
    @POST
    @Produces(value={"text/plain"})
    public Response uploadFile(@PathParam(value="fileName") String fileName, String content) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelFileName", fileName);
        headers.put("Content-Type", "text/plain");
        Exchange result = this.producerTemplate.request("mongodb-gridfs:camelMongoClient?database=test&operation=create", exchange -> {
            exchange.getMessage().setHeaders(headers);
            exchange.getMessage().setBody((Object)content);
        });
        return Response.created((URI)new URI("https://camel.apache.org/")).entity(result.getMessage().getHeader("gridfs.objectid")).build();
    }

    @Path(value="/get/{fileName}")
    @GET
    @Produces(value={"text/plain"})
    public Response retrieveFile(@PathParam(value="fileName") String fileName) {
        String result;
        block2: {
            result = null;
            try {
                result = (String)this.producerTemplate.requestBodyAndHeader("mongodb-gridfs:camelMongoClient?database=test&operation=findOne", null, "CamelFileName", (Object)fileName, String.class);
            }
            catch (Exception e) {
                if (!(e.getCause() instanceof MongoGridFSException)) break block2;
                return Response.status((int)404).build();
            }
        }
        return Response.ok().entity(result).build();
    }

    @Path(value="/delete/{fileName}")
    @DELETE
    public Response deleteFile(@PathParam(value="fileName") String fileName) {
        this.producerTemplate.requestBodyAndHeader("mongodb-gridfs:camelMongoClient?database=test&operation=remove", null, "CamelFileName", (Object)fileName);
        return Response.noContent().build();
    }
}

