/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mongodb.it;

import com.mongodb.client.MongoIterable;
import java.net.URI;
import java.net.URISyntaxException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;
import org.bson.Document;

@Path(value="/mongodb")
@ApplicationScoped
public class MongoDbResource {
    @Inject
    ProducerTemplate producerTemplate;

    @POST
    @Path(value="/collection/{collectionName}")
    @Consumes(value={"application/json"})
    public Response writeToCollection(@PathParam(value="collectionName") String collectionName, String content) throws URISyntaxException {
        this.producerTemplate.sendBody("mongodb:camelMongoClient?database=test&collection=" + collectionName + "&operation=insert&dynamicity=true", (Object)content);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @GET
    @Path(value="/collection/{collectionName}")
    @Produces(value={"application/json"})
    public JsonArray getCollection(@PathParam(value="collectionName") String collectionName) {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        MongoIterable iterable = (MongoIterable)this.producerTemplate.requestBody("mongodb:camelMongoClient?database=test&collection=" + collectionName + "&operation=findAll&dynamicity=true&outputType=MongoIterable", null, MongoIterable.class);
        for (Document document : iterable) {
            JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
            objectBuilder.add("message", (String)document.get((Object)"message"));
            arrayBuilder.add((JsonValue)objectBuilder.build());
        }
        return arrayBuilder.build();
    }
}

